/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.license;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class NetworkUtils {
    public static Set<String[]> getMacList() throws SocketException {
        NetworkInterfaceData[] networkInterfaces = NetworkUtils.getNetworkInterfaces();
        Set<String[]> macList = NetworkUtils.getMac(networkInterfaces);
        return macList;
    }

    private static Set<String[]> getMac(NetworkInterfaceData[] networkInterfaces) {
        HashSet<String[]> macSet = new HashSet<String[]>();
        NetworkInterfaceData[] networkInterfaceDataArray = networkInterfaces;
        int n = networkInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkInterfaceData ni = networkInterfaceDataArray[n2];
            if (ni.hwAddress != null) {
                StringBuffer sb = new StringBuffer(18);
                int i = 0;
                while (i < ni.hwAddress.length) {
                    String s;
                    if (i != 0) {
                        sb.append("-");
                    }
                    sb.append((s = Integer.toHexString(ni.hwAddress[i] & 0xFF)).length() == 1 ? String.valueOf(0) + s : s);
                    ++i;
                }
                macSet.add(new String[]{ni.name, sb.toString().toUpperCase()});
            }
            ++n2;
        }
        return macSet;
    }

    private static int numberOfInterfaces() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        int interfaceCounter = 0;
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!NetworkUtils.weShouldUseForTheCalculationThis(networkInterface)) continue;
            ++interfaceCounter;
        }
        return interfaceCounter;
    }

    private static NetworkInterfaceData[] getNetworkInterfaces() throws SocketException {
        NetworkInterfaceData[] networkInterfaceArray = new NetworkInterfaceData[NetworkUtils.numberOfInterfaces()];
        int index = 0;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!NetworkUtils.weShouldUseForTheCalculationThis(networkInterface)) continue;
            networkInterfaceArray[index] = new NetworkInterfaceData(networkInterface);
            ++index;
        }
        return networkInterfaceArray;
    }

    private static boolean weShouldUseForTheCalculationThis(NetworkInterface networkInterface) throws SocketException {
        return !networkInterface.isLoopback() && !networkInterface.isVirtual() && !networkInterface.isPointToPoint();
    }

    private static class NetworkInterfaceData {
        String name;
        byte[] hwAddress;

        public NetworkInterfaceData(NetworkInterface networkInterface) throws SocketException {
            this.name = networkInterface.getName();
            this.hwAddress = networkInterface.getHardwareAddress();
        }
    }
}

