/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.license;

import com.kdgcsoft.power.license.LicenseInfo;
import com.kdgcsoft.power.license.NetworkUtils;
import com.verhas.licensor.License;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;

public class LicenseClient {
    License lic = new License();
    LicenseInfo licInfo;

    public LicenseClient() throws IOException {
        this.lic.loadKeyRingFromResource("pubring.gpg", null);
    }

    public LicenseClient(InputStream pubRingFileStream) throws IOException {
        if (pubRingFileStream == null) {
            throw new IOException("\u65e0\u6cd5\u6253\u5f00\u6587\u4ef6");
        }
        this.lic.loadKeyRing(pubRingFileStream, null);
    }

    public LicenseInfo loadLicense(File filePath) {
        try {
            this.lic.setLicenseEncoded(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PGPException e) {
            e.printStackTrace();
        }
        this.exactInfo();
        return this.licInfo;
    }

    private void exactInfo() {
        this.licInfo = new LicenseInfo();
        this.licInfo.setCustomerName(this.lic.getFeature("CustomerName"));
        this.licInfo.setProjectName(this.lic.getFeature("ProjectName"));
        this.licInfo.setProductionName(this.lic.getFeature("ProductionName"));
        this.licInfo.setLicType(this.lic.getFeature("LicType"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            this.licInfo.setIssueDate(sdf.parse(this.lic.getFeature("IssueDate")));
            this.licInfo.setValidDate(sdf.parse(this.lic.getFeature("ValidDate")));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u6388\u6743\u6587\u4ef6\uff01");
        }
        this.licInfo.setMacAddress(this.lic.getFeature("MacAddress"));
        this.licInfo.setUserLimits(Integer.parseInt(this.lic.getFeature("UserLimits")));
    }

    public LicenseInfo getLicenseInfo() {
        return this.licInfo;
    }

    public void validate() throws IllegalArgumentException {
        this.validateDate();
        this.validateMacAddress();
    }

    public void validateDate() {
        if (this.licInfo.getIssueDate().after(new Date())) {
            throw new IllegalArgumentException("\u5f53\u524d\u65e5\u671f\u65e9\u4e8e\u53d1\u884c\u65e5\u671f\uff0c\u65f6\u95f4\u53ef\u80fd\u88ab\u4eba\u4e3a\u8c03\u6574\u4e86\uff01");
        }
        if (this.licInfo.getValidDate() == null) {
            return;
        }
        if (this.licInfo.getValidDate().before(new Date())) {
            throw new IllegalArgumentException("\u6388\u6743\u6709\u6548\u65f6\u95f4\u5df2\u8fc7\uff01");
        }
    }

    public void validateMacAddress() {
        if (this.licInfo == null) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528loadLicense()\u52a0\u8f7d\u6388\u6743\u6587\u4ef6\uff01");
        }
        if (this.licInfo.getMacAddress() != null && !"".equals(this.licInfo.getMacAddress().trim())) {
            String mac = this.licInfo.getMacAddress().trim();
            try {
                Set<String[]> list = NetworkUtils.getMacList();
                for (String[] item : list) {
                    if (!mac.equals(item[1])) continue;
                    return;
                }
                throw new IllegalArgumentException("\u5f53\u524d\u786c\u4ef6\u4e0e\u6388\u6743\u6587\u4ef6\u4e0d\u7b26\uff01");
            }
            catch (SocketException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("\u83b7\u53d6\u786c\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        System.out.println("\u6388\u6743\u6587\u4ef6\u4e2d\u65e0\u786c\u4ef6\u4fe1\u606f\uff0c\u89c6\u4e3a\u4e0d\u68c0\u67e5\u786c\u4ef6\uff01");
    }

    public static void main(String[] args) throws UnsupportedEncodingException, SocketException, UnknownHostException {
        Set<String[]> list = NetworkUtils.getMacList();
        for (String[] pair : list) {
            System.out.println(String.valueOf(pair[0]) + " : " + pair[1]);
        }
    }
}

