/*
 * Decompiled with CFR 0.152.
 */
import com.verhas.licensor.License;
import com.verhas.utils.CommandLineProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;

public class License3j {
    private static final String commandLineString = "java -cp license3j.jar License3j";
    private static CommandLineProcessor commandLine;
    private static PrintStream errorOutput;

    static {
        errorOutput = System.err;
    }

    private void encode() throws Exception {
        try {
            FileOutputStream os = new FileOutputStream(commandLine.option("output"));
            ((OutputStream)os).write(new License().setLicense(new File(commandLine.option("license-file"))).loadKey(commandLine.option("keyring-file"), commandLine.option("key")).encodeLicense(commandLine.option("password")).getBytes("utf-8"));
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            errorOutput.print("Usage: java -cp license3j.jar License3j encode options\n mandatory options are: \n--license-file, --keyring-file, --key, --password, --output\n");
            throw e;
        }
    }

    private void decode() throws Exception {
        try {
            License license = new License();
            if (license.loadKeyRing(commandLine.option("keyring-file"), null).setLicenseEncodedFromFile(commandLine.option("license-file")).isVerified()) {
                OutputStream os = System.out;
                if (commandLine.optionExists("output").booleanValue()) {
                    os = new FileOutputStream(commandLine.option("output"));
                }
                OutputStreamWriter w = null;
                w = commandLine.optionExists("charset") != false ? new OutputStreamWriter(os, commandLine.option("charset")) : new OutputStreamWriter(os);
                w.write("---LICENSE STRING PLAIN TEXT START\n");
                ((Writer)w).flush();
                license.dumpLicense(os);
                os.flush();
                w.write("---LICENSE STRING PLAIN TEXT END\n");
                w.write("Encoding license key id=" + license.getDecodeKeyId() + "L\n");
                w.write("---KEY RING DIGEST START\n");
                w.write(license.dumpPublicKeyRingDigest());
                w.write("---KEY RING DIGEST END\n");
                ((Writer)w).close();
                os.close();
            } else {
                errorOutput.println("The license can not be verified.");
            }
        }
        catch (Exception e) {
            License3j.printUsage(null);
            e.printStackTrace(errorOutput);
            throw e;
        }
    }

    private static void printUsage(String[] args) {
        errorOutput.print("Usage: java -cp license3j.jar License3j decode options\n mandatory options are: \n--license-file, --keyring-file, [ --output ] [--charset]\n");
        errorOutput.println("Usage: java -cp license3j.jar License3j command options\ncommands available: \n      * encode\n      * decode\narguments to the different commands type the command w/o args");
        if (args != null) {
            errorOutput.println("Arguments on the command line:");
            int i = 1;
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                errorOutput.println(String.valueOf(i) + ". " + arg);
                ++i;
                ++n2;
            }
            errorOutput.println("Command line options:");
            i = 1;
            for (String opt : commandLine.getOptions().keySet()) {
                errorOutput.println(String.valueOf(i) + ". option[" + opt + "]=" + commandLine.option(opt));
                ++i;
            }
        }
        errorOutput.println("Current working directory " + System.getProperties().get("user.dir"));
    }

    public static void main(String[] args) throws Exception {
        commandLine = new CommandLineProcessor();
        if (args == null || args.length == 0) {
            License3j.printUsage(args);
            return;
        }
        commandLine.process(args);
        if (commandLine.getFiles().size() < 1) {
            License3j.printUsage(args);
            return;
        }
        String command = commandLine.getFiles().get(0);
        if ("encode".equals(command)) {
            new License3j().encode();
        }
        if ("decode".equals(command)) {
            new License3j().decode();
        }
    }
}

