package com.kdgcsoft.power.filemanager;

/**
 * 从FileManager请求指定格式文件时返回的文件信息，主要用于下载或预览。
 * @author hling
 *
 */
public class RequestDocInfo {
	/**
	 * 文件Key
	 */
	private String key = null;
	/**
	 * 文件原始文件名
	 */
	private String originalFileName = null;
	/**
	 * 用户放入FileManager的原始文件字节流。用于下载。
	 */
//	private InputStream originalFileStream = null;
	/**
	 * 想要获取的目标文件格式扩展名（通常用于预览）。该属性在通过FileManager获取文件信息时作为参数传入，并在结果中直接返回。
	 */
	private String wantType = null;
	/**
	 * FileManager是否有能力提供这种格式的文件。如果进入FileManager的源文件就是该格式、或FileManager能够把源文件转换为该格式，则为true，否则为false。
	 * 注意：有能力提供这种格式并不代表当前这种格式的文件一定存在。
	 * 如果没有正确设置自动转换或手动触发转换，目标格式的文件可能并不存在，此时虽然supportWantType为true，但wantFilesCount属性为0。
	 * 应用程序可以结合本属性以及{@link wantFilesCount}属性判断是否有必要进行手动转换。
	 */
	private boolean supportWantType = false;
	/**
	 * 目标格式的文件个数。例如转换成png图片时会生成多个文件。默认为1，即预览文件是单文件。
	 */
	private int wantFilesCount = 1;
	
	/**
	 * 文件Key
	 * @return 文件Key
	 */
	public String getKey() {
		return key;
	}
	void setKey(String key) {
		this.key = key;
	}
	/**
	 * 文件原始文件名
	 * @return 文件原始文件名
	 */
	public String getOriginalFileName() {
		return originalFileName;
	}
	void setOriginalFileName(String originalFileName) {
		this.originalFileName = originalFileName;
	}
	/**
	 * 用户放入FileManager的原始文件字节流。用于下载
	 * @return 字节流对象
	 */
//	public InputStream getOriginalFileStream() {
//		return originalFileStream;
//	}
//	void setOriginalFileStream(InputStream originalFileStream) {
//		this.originalFileStream = originalFileStream;
//	}
	/**
	 * 想要获取的目标文件格式扩展名（通常用于预览）。该属性在通过FileManager获取文件信息时作为参数传入，并在结果中直接返回。
	 * 返回例："pdf"、"html"、"bmp"、"txt"、"zip"、"jpg"
	 * @return 目标文件格式
	 */
	public String getWantType() {
		return wantType;
	}
	void setWantType(String wantType) {
		this.wantType = wantType;
	}
	/**
	 * FileManager是否有能力提供这种格式的文件。<br>
	 * 如果进入FileManager的源文件就是该格式、或FileManager能够把源文件转换为该格式，则为true，否则为false。 <br>
	 * 注意：有能力提供这种格式并不代表这种格式的文件当前一定存在。 
	 * 如果没有正确设置自动转换或手动触发转换，目标格式的文件可能并不存在。
	 * 此时虽然supportWantType为true，但wantFilesCount属性为0。<br> 
	 * 应用程序可以结合本属性以及wantFilesCount属性判断是否有必要进行手动转换。
	 * @return FileManager是否有能力提供这种格式的文件
	 */
	public boolean isSupportWantType() {
		return supportWantType;
	}
	void setSupportWantType(boolean supportWantType) {
		this.supportWantType = supportWantType;
	}
	/**
	 * 目标格式的文件个数。例如转换成png图片时会生成多个文件。默认为1，即预览文件是单文件。
	 * @return 目标格式的文件个数
	 */
	public int getWantFilesCount() {
		return wantFilesCount;
	}
	void setWantFilesCount(int wantFilesCount) {
		this.wantFilesCount = wantFilesCount;
	}
	
}
