package com.kdgcsoft.power.fileconverter.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.slf4j.Logger;

/**
 * 用来接收外部命令行程序的输出流
 * @author hling
 *
 */
public class StreamGobbler extends Thread {
	private Logger logger;
	private InputStream is;
	private String printHeader;

	public StreamGobbler(Logger logger, InputStream is, String printHeader) {
		this.logger = logger;
		this.is = is;
		this.printHeader = printHeader;
	}

	public void run() {
		try {
			InputStreamReader isr = new InputStreamReader(is);
			BufferedReader br = new BufferedReader(isr);
			String line = null;
			while ((line = br.readLine()) != null) {
				if (printHeader != null && !"".equals(printHeader)) {
					logger.info(printHeader + ">" + line);
				} else {
					logger.info(">" + line);
				}
			}
				
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}
}