package com.kdgcsoft.power.fileconverter.impl;

import java.io.File;

import com.kdgcsoft.power.excel2html.Excel2Html;
import com.kdgcsoft.power.fileconverter.FileConverterSettings;
import com.kdgcsoft.power.fileconverter.IFileConverter;

/**
 * 把Excel(*.xls,*.xlsx)转换成*.html的转换器，不支持Excel文件中的图表、图片等图形元素。
 * @author hling
 *
 */
public class Excel2HtmlConverter implements IFileConverter {

	@Override
	public File convert(final File srcFile, final File targetFile, final FileConverterSettings settings) throws Exception {
		// Excel转HTML
		Excel2Html toHtml = Excel2Html.create(srcFile);
		
		toHtml.setShowHeaders(settings.isExcel2HtmlShowHeaders());
		toHtml.setShowHiddenContent(settings.isExcel2htmlShowHiddenContent());
		toHtml.setHideSheetTabIfOnlyOne(settings.isExcel2HtmlHideTabIfOnlyOne());
		if (settings.getExcel2HtmlTemplate() != null) {
			toHtml.setHtmlTemplate(settings.getExcel2HtmlTemplate());
		}
		
		toHtml.toFile(targetFile);
		toHtml.close();
		return targetFile;
	}
}
