package com.kdgcsoft.power.fileconverter;

import java.io.File;

/**
 * 转换器抽象接口
 * @author hling
 *
 */
public interface IFileConverter {
	
	/**
	 * 文档转换接口定义。
	 * 对转换器的实现要求：
	 * 如果转换器是把源文件转成单个目标文件，则转换结果文件必须与参数destFile完全一致，并返回结果文件对象
	 * 如果转换器是把源文件转成多个目标文件（分页），则转换结果文件必须放在参数destFile+".dir"结尾的目录中，且该目录必须与destFile处于相同位置，并返回目录对象。
	 * 转换器的调用者将根据返回的File对象是文件还是目录做不同的处理。
	 * 
	 * @param srcFile 待转换的源文件
	 * @param destFile 要转换成为的目标文件
	 * @param settings 转换设置
	 * @return 如果转换后是一个单独文件，则返回文件对象。如果转换生成了一系列分页文件，则返回这些分页文件所在的目录对象，即[destFile+".dir"]目录。
	 * @throws Exception
	 */
	public File convert(final File srcFile, final File destFile, final FileConverterSettings settings) throws Exception;

}
