package com.kdgcsoft.power.fileconverter.storage;
import java.io.File;
import java.util.UUID;

import com.kdgcsoft.power.fileconverter.IFileStorageHelper;

/**
 * 基于UUID实现的的本地文件管理方式
 * @author hling
 *
 */
public class UUIDStorage implements IFileStorageHelper {

	@Override
	public String generateKey() {
		return UUID.randomUUID().toString();
	}

	/* 
	 * 使用UUID的前两个字符建立两级目录，
	 * 即每级目录名为0~F共16个，所有文件总共分配在256个目录下存储。
	 * (non-Javadoc)
	 * @see com.kdgcsoft.power.doc.convert.IFileStorageHelper#getRelativePathByKey(java.lang.String)
	 */
	@Override
	public String getRelativePathByKey(final String key) {
		String realtivePath = key.substring(0, 2) + File.separator + key.substring(2, 4);
		return realtivePath;
	}

	@Override
	public void validateKey(final String key) throws IllegalArgumentException {
		if (key == null) {
			throw new IllegalArgumentException("Key不能为null!");
		}
		UUID.fromString(key);
	}

}
