package com.kdgcsoft.power.fileconverter.impl;

import java.io.File;
import java.util.Date;

import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.kdgcsoft.power.fileconverter.FileConverterException;
import com.kdgcsoft.power.fileconverter.FileConverterSettings;
import com.kdgcsoft.power.fileconverter.IFileConverter;
/**
 * 基于WPS进行文档转换
 * @author Administrator
 *
 */
public class WpsOfficeConverter implements IFileConverter {
	private static Logger logger = LoggerFactory.getLogger(WpsOfficeConverter.class);
	public final static String WORDSERVER_STRING="KWPS.Application";  
    public final static String PPTSERVER_STRING="KWPP.Application";  
    public final static String EXECLSERVER_STRING="KET.Application";  
    private static final int wdFormatPDF = 17;  //WPS word转PDF的宏值
    private static final int xlTypePDF = 0;  
    private static final int ppSaveAsPDF = 32;
//    private static final int wdFormatHTML = 9;
    /*转HTML格式值*/  
    private static final int wdFormatHTML = 8;  
    private static final int ppFormatHTML = 12;  
    private static final int xlFormatHTML = 44;  
    
    
	@Override
	public File convert(File srcFile, File destFile, FileConverterSettings settings) throws Exception {
		if(!srcFile.exists()){  
        	logger.info("{}该文件不存在!", srcFile.getName());            
        	
        }else{
        	String suffix =  FilenameUtils.getExtension(srcFile.getName());
	        if(suffix.equals("pdf")){
	            logger.info("{}PDF not need to convert!", srcFile.getName());
	        }  
	        if(suffix.equalsIgnoreCase("doc")||suffix.equalsIgnoreCase("docx")){
	            word2PDF(srcFile.getAbsolutePath(),destFile.getAbsolutePath()); 
	        }else if(suffix.equalsIgnoreCase("ppt")||suffix.equalsIgnoreCase("pptx")){  
	            ppt2PDF(srcFile.getAbsolutePath(),destFile.getAbsolutePath());  
	        }else if(suffix.equalsIgnoreCase("xls")||suffix.equalsIgnoreCase("xlsx")){  
	            excel2PDF(srcFile.getAbsolutePath(),destFile.getAbsolutePath());
	        }else{
	            logger.error("{}文件格式不支持转换!", srcFile.getName());
	            throw new FileConverterException(srcFile.getName()+"文件格式不支持转换!");
	        }  
        }
        
        return destFile;
	}
	
	
	/**
	 * Word文档转为PDF
	 * @param inputFile
	 * @param pdfFile
	 * @throws FileConverterException
	 */
	public void word2PDF(String inputFile, String pdfFile) throws FileConverterException {
		ActiveXComponent app=null;
		ActiveXComponent workbook = null;   
		try {
			ComThread.InitMTA(true);
			// 打开word应用程序
			app = new ActiveXComponent(WORDSERVER_STRING);
			// 设置word不可见
			Variant[] openParams=new Variant[]{  
                    new Variant(inputFile),//filePath  
                    new Variant(true),  
                    new Variant(true)//readOnley  
             }; 
			workbook = app.invokeGetComponent("Documents").invokeGetComponent  
                    ("Open",openParams);
			// 获得word中所有打开的文档,返回Documents对象
			// 调用Documents对象中Open方法打开文档，并返回打开的文档对象Document
			workbook.invoke("SaveAs",new Variant(pdfFile),new Variant(wdFormatPDF)); 
			// 调用Document对象的SaveAs方法，将文档保存为pdf格式
			/*
			 * Dispatch.call(doc, "SaveAs", pdfFile, wdFormatPDF
			 * //word保存为pdf格式宏，值为17 );
			 */
			//Dispatch.call(doc, "ExportAsFixedFormat", pdfFile, wdFormatPDF );// word保存为pdf格式宏，值为17
			return;
		} catch (Exception e) {
	         throw new FileConverterException(inputFile+"文件转换失败!", e);
		}finally{  
            if(workbook!=null)  
            {  
                workbook.invoke("Close");   
                workbook.safeRelease();   
            }  
            if(app!=null)  
            {            
            	app.invoke("Quit");   
            	app.safeRelease();  
            }  
            ComThread.Release();    
            ComThread.quitMainSTA();
        } 
	}
	
	
	/**
	 * PowerPoint文档转换为PDF
	 * @param inputFile 源PPT文件
	 * @param pdfFile 目标PDF文件
	 * @throws FileConverterException
	 */
	public void ppt2PDF(String inputFile, String pdfFile) throws FileConverterException {
		ActiveXComponent app=null;
		 ActiveXComponent workbook = null;
		boolean readonly = true; 
		try {
			ComThread.InitMTA(true);
			app = new ActiveXComponent(PPTSERVER_STRING);//初始化exe程序    
            workbook = app.invokeGetComponent("Presentations").invokeGetComponent  
                   ("Open",new Variant(inputFile),new Variant(readonly));  
            workbook.invoke("SaveAs",new Variant(pdfFile),new Variant(ppSaveAsPDF));  
			return;
		} catch (Exception e) {
	         throw new FileConverterException(inputFile+"文件转换失败!", e);
		}finally {
			if (workbook != null) {  
                //workbook.invoke("Close");注释掉这一句不影响内存占用和程序关闭,如果不注释会在多线程情况下引发报错
                workbook.safeRelease();
            }
            if (app != null) {  
            	// 关闭word应用程序
    			app.invoke("Quit");
    			app.safeRelease();
            }
            ComThread.Release(); //释放进程
            ComThread.quitMainSTA();//释放主进程
            
        } 
	}
	
	
	/**
	 * Excel文档转换为PDF
	 * @param inputFile Excel文件
	 * @param pdfFile 目标PDF文件
	 * @throws FileConverterException
	 */
	public void excel2PDF(String inputFile, String pdfFile) throws FileConverterException {
		ActiveXComponent app=null;
		Dispatch excel = null;
		try {
            ComThread.InitSTA(true);
            app = new ActiveXComponent(EXECLSERVER_STRING);
            app.setProperty("Visible", false);
            app.setProperty("AutomationSecurity", new Variant(3)); // 禁用宏
            Dispatch excels = app.getProperty("Workbooks").toDispatch();

            excel = Dispatch
                    .invoke(excels, "Open", Dispatch.Method,
                            new Object[] { inputFile, new Variant(false), new Variant(false) }, new int[9])
                    .toDispatch();
            // 转换格式
            Dispatch.invoke(excel, "ExportAsFixedFormat", Dispatch.Method, new Object[] { new Variant(0), // PDF格式=0
                    pdfFile, new Variant(xlTypePDF) // 0=标准 (生成的PDF图片不会变模糊) 1=最小文件
                                            // (生成的PDF图片糊的一塌糊涂)
            }, new int[1]);

            // 这里放弃使用SaveAs
            /*
             * Dispatch.invoke(excel,"SaveAs",Dispatch.Method,new Object[]{
             * outFile, new Variant(57), new Variant(false), new Variant(57),
             * new Variant(57), new Variant(false), new Variant(true), new
             * Variant(57), new Variant(true), new Variant(true), new
             * Variant(true) },new int[1]);
             */
           

        } catch (Exception e) {
	         throw new FileConverterException(inputFile+"文件转换失败!", e);
		}finally {
			if (excel != null) {  
				 Dispatch.call(excel, "Close", new Variant(false));
				 excel.safeRelease();
           }
           if (app != null) {  
           	// 关闭word应用程序
   			app.invoke("Quit");
   			app.safeRelease();
           }
           ComThread.Release(); //释放进程
           ComThread.quitMainSTA();
           
       } 
	}
	
	public static void main(String[] args) throws FileConverterException {
		WpsOfficeConverter convert=new WpsOfficeConverter();
		convert.word2PDF("D://aaaaa.docx", "D://aaaaa.pdf");
		
	}
}
