package com.kdgcsoft.power.fileconverter.impl;

import java.io.File;
import java.util.Random;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kdgcsoft.power.fileconverter.FileConverterSettings;
import com.kdgcsoft.power.fileconverter.IFileConverter;

/**
 * 用于测试的虚拟转换器。其功能仅仅是创建一个0字节的转换目标文件。
 * @author hling
 *
 */
public class DummyConverter implements IFileConverter {
	
	private static final Logger logger = LoggerFactory.getLogger(DummyConverter.class);

	@Override
	public File convert(File srcFile, File destFile, final FileConverterSettings settings) throws Exception {
		// 随机延迟，模拟任务执行时间
		int delay = (new Random()).nextInt(10);
		logger.info("虚拟转换，延迟{}秒", delay);
		
		Thread.sleep(delay * 1000L);	
		FileUtils.touch(destFile);
		
		return destFile;
	}

}
