package com.kdgcsoft.power.fileconverter;

/**
 * 转换后的文档在本地存储的方式
 * @author hling
 *
 */
public enum StorageType {
	/**
	 * 文件Key是UUID，并基于UUID构造存储目录结构 
	 */
	UUID,
	/**
	 * 文件Key是时间戳，并基于时间戳构造存储目录结构
	 */
	TimeStamp,
	/**
	 * 文件Key是字母和数字的任意组合，并基于Key的最后两位字符构造存储目录结构。
	 * 一般用于应用程序希望使用自定义Key的场景。
	 */
	FreeStyle
}
