/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.doccenter;

import com.kdgcsoft.power.doc.convert.ConvertEngineType;
import com.kdgcsoft.power.doc.convert.DocConvertService;
import com.kdgcsoft.power.doc.convert.DocConvertSettings;
import com.kdgcsoft.power.doc.convert.StorageType;
import com.kdgcsoft.power.doccenter.AutoConvertStrategy;
import com.kdgcsoft.power.doccenter.DocCenter;
import com.kdgcsoft.power.filestore.FileStore;
import com.kdgcsoft.power.filestore.FileStoreException;
import com.kdgcsoft.power.filestore.LocalJackRabbitFileStore;
import com.kdgcsoft.power.filestore.RemoteJackRabbitFileStore;
import com.kdgcsoft.power.filestore.TimeStampSimpleFileStore;
import com.kdgcsoft.power.filestore.UUIDSimpleFileStore;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocCenterBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DocCenterBuilder.class);
    private String baseDir;
    private IDType idType = IDType.timestamp;
    private boolean useJackrabbit = false;
    private String jackrabbitURL = "";
    private String jackrabbitUser = "admin";
    private String jackrabbitPassword = "admin";
    private boolean autoConvert = true;
    private AutoConvertStrategy convertStrategy = null;
    private DocConvertSettings convertSettings = new DocConvertSettings();

    private DocCenterBuilder() {
    }

    public static DocCenterBuilder newInstance() {
        return new DocCenterBuilder();
    }

    public DocCenterBuilder setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public DocCenterBuilder setIdType(IDType idType) {
        this.idType = idType;
        return this;
    }

    public DocCenterBuilder setUseJackrabbit(String urlOrDir, String user, String password) {
        this.useJackrabbit = true;
        this.jackrabbitURL = urlOrDir;
        this.jackrabbitUser = user;
        this.jackrabbitPassword = password;
        return this;
    }

    public DocCenterBuilder setAutoConvert(boolean autoConvert) {
        this.autoConvert = autoConvert;
        return this;
    }

    public DocCenterBuilder setConvertStrategy(AutoConvertStrategy convertStrategy) {
        this.convertStrategy = convertStrategy;
        return this;
    }

    public DocCenterBuilder setConvertTestMode(boolean isTestMode) {
        this.convertSettings.setTestMode(isTestMode);
        return this;
    }

    public DocCenterBuilder setConvertEngine(ConvertEngineType engine) {
        this.convertSettings.setConvertEngine(engine);
        return this;
    }

    public DocCenterBuilder setMaxConvertThread(int maxConvertThread) {
        this.convertSettings.setMaxConvertThread(maxConvertThread);
        return this;
    }

    public DocCenterBuilder setPdf2HtmlExePath(String exePath) {
        this.convertSettings.setPdf2HtmlExePath(exePath);
        return this;
    }

    public DocCenterBuilder setOpenOfficeDirectory(String openOfficeDir) {
        this.convertSettings.setOpenOfficePath(openOfficeDir);
        return this;
    }

    public DocCenterBuilder setOpenOfficePorts(int[] ports) {
        this.convertSettings.setOpenOfficePorts(ports);
        return this;
    }

    public DocCenterBuilder setExcel2HtmlShowHeaders(boolean excel2html_showHeaders) {
        this.convertSettings.setExcel2HtmlShowHeaders(excel2html_showHeaders);
        return this;
    }

    public DocCenterBuilder setExcel2HtmlShowHiddenContent(boolean excel2html_showHiddenContent) {
        this.convertSettings.setExcel2HtmlShowHiddenContent(excel2html_showHiddenContent);
        return this;
    }

    public DocCenterBuilder setExcel2HtmlHideTabIfOnlyOne(boolean excel2html_hideTabIfOnlyOne) {
        this.convertSettings.setExcel2HtmlHideTabIfOnlyOne(excel2html_hideTabIfOnlyOne);
        return this;
    }

    public DocCenterBuilder setExcel2HtmlJQueryPath(String excel2html_jqueryPath) {
        this.convertSettings.setExcel2HtmlJQueryPath(excel2html_jqueryPath);
        return this;
    }

    public DocCenterBuilder setExcel2HtmlTemplateStr(String excel2html_htmlTemplate) {
        this.convertSettings.setExcel2HtmlTemplateStr(excel2html_htmlTemplate);
        return this;
    }

    public DocCenterBuilder setConvertSettings(DocConvertSettings settings) {
        if (settings != null) {
            this.convertSettings = settings;
        } else {
            logger.warn("setConvertSettings\u53c2\u6570\u4e3anull\u3002\u5c06\u4f7f\u7528\u9ed8\u8ba4\u8f6c\u6362\u8bbe\u7f6e\u3002");
        }
        return this;
    }

    public DocCenter create() throws IOException, FileStoreException {
        Object fileStore;
        DocCenter docCenter = new DocCenter();
        File baseDir = new File(this.baseDir);
        baseDir = new File(baseDir.getAbsolutePath());
        if (this.useJackrabbit) {
            fileStore = this.jackrabbitURL.startsWith("http") ? new RemoteJackRabbitFileStore(this.jackrabbitURL, this.jackrabbitUser, this.jackrabbitPassword) : new LocalJackRabbitFileStore(this.jackrabbitURL, this.jackrabbitUser, this.jackrabbitPassword);
            this.idType = IDType.uuid;
        } else {
            String fileStoreBaseDir = new File(baseDir, "file_storage").getAbsolutePath();
            fileStore = IDType.timestamp.equals((Object)this.idType) ? new TimeStampSimpleFileStore(fileStoreBaseDir) : new UUIDSimpleFileStore(fileStoreBaseDir);
        }
        docCenter.setFileStore((FileStore)fileStore);
        String convertBaseDir = new File(baseDir, "convert_storage").getAbsolutePath();
        this.convertSettings.setWorkdir(new File(convertBaseDir));
        if (IDType.timestamp.equals((Object)this.idType)) {
            this.convertSettings.setStorageType(StorageType.TimeStamp);
        } else {
            this.convertSettings.setStorageType(StorageType.UUID);
        }
        DocConvertService.init((DocConvertSettings)this.convertSettings);
        docCenter.setAutoConvert(this.autoConvert);
        if (this.convertStrategy != null) {
            docCenter.setConvertStrategy(this.convertStrategy);
        }
        return docCenter;
    }

    public static enum IDType {
        uuid,
        timestamp;

    }
}

