/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.doccenter;

import com.kdgcsoft.power.doc.convert.DocConvertException;
import com.kdgcsoft.power.doc.convert.DocConvertService;
import com.kdgcsoft.power.doc.convert.OutputType;
import com.kdgcsoft.power.doccenter.AutoConvertStrategy;
import com.kdgcsoft.power.filestore.FileInfo;
import com.kdgcsoft.power.filestore.FileStore;
import com.kdgcsoft.power.filestore.FileStoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocCenter {
    private static final Logger logger = LoggerFactory.getLogger(DocCenter.class);
    private static final String[] CAN_PREVIEW_EXTS = new String[]{"jpg", "jepg", "bmp", "png", "gif", "ico"};
    private static final String[] CAN_CONVERT_EXTS = new String[]{"doc", "docx", "ppt", "pptx", "xls", "xlsx", "pdf"};
    private FileStore fileStore;
    private boolean autoConvert = true;
    private AutoConvertStrategy convertStrategy = AutoConvertStrategy.createDefaultStrategy();

    DocCenter() {
    }

    void setFileStore(FileStore store) {
        this.fileStore = store;
    }

    void setAutoConvert(boolean autoConvert) {
        this.autoConvert = autoConvert;
    }

    void setConvertStrategy(AutoConvertStrategy convertStrategy) {
        this.convertStrategy = convertStrategy;
    }

    public FileInfo putFile(File file) throws FileStoreException, DocConvertException {
        return this.putFile(file, file.getName());
    }

    public FileInfo putFile(File file, String fileName) throws FileStoreException, DocConvertException {
        try {
            return this.putFileAsStream(new FileInputStream(file), fileName);
        }
        catch (FileNotFoundException e) {
            throw new FileStoreException((Throwable)e);
        }
    }

    public FileInfo putFileAsStream(InputStream stream, String fileName) throws FileStoreException, DocConvertException {
        String ext;
        Collection<OutputType> strategy;
        FileInfo info = this.fileStore.putFileAsStream(stream, fileName);
        if (this.autoConvert && (strategy = this.convertStrategy.getConvertStrategy(ext = FilenameUtils.getExtension((String)fileName))) != null) {
            for (OutputType type : strategy) {
                InputStream is = this.fileStore.getFileAsStream(info.getKey());
                DocConvertService.convert((InputStream)is, (String)fileName, (String)info.getKey(), (OutputType)type);
            }
        }
        return info;
    }

    public FileInfo getFile(String key) throws FileStoreException {
        return this.fileStore.getFile(key);
    }

    public InputStream getFileAsStream(String key) throws FileStoreException {
        return this.fileStore.getFileAsStream(key);
    }

    public void deleteFile(String key) throws FileStoreException {
        this.fileStore.deleteFile(key);
        DocConvertService.deleteConvertedFileQuietly((String)key);
    }

    public void close() {
        DocConvertService.finish();
    }

    public FileInfo getFile(String key, OutputType outType, boolean autoConvert) throws FileStoreException, DocConvertException {
        FileInfo fileInfo = this.fileStore.getFile(key);
        if (fileInfo == null) {
            throw new FileStoreException("\u5728\u6587\u4ef6\u5b58\u50a8\u5e93\u4e2d\u627e\u4e0d\u5230\u6587\u4ef6\u3002Key=" + key);
        }
        String fileName = fileInfo.getFileName().toLowerCase();
        if (FilenameUtils.isExtension((String)fileName, (String[])CAN_CONVERT_EXTS)) {
            File convertedFile = DocConvertService.getConvertedFile((String)key, (OutputType)outType);
            if (convertedFile == null) {
                if (autoConvert) {
                    DocConvertService.convert((InputStream)fileInfo.getInputStream(), (String)fileName, (String)key, (OutputType)outType);
                    convertedFile = DocConvertService.getConvertedFile((String)key, (OutputType)outType);
                } else {
                    logger.info("{}\u6587\u4ef6\u5c1a\u672a\u88ab\u8f6c\u6362\u6210{}\u683c\u5f0f", (Object)key, (Object)outType.toString());
                    return null;
                }
            }
            if (convertedFile.isFile()) {
                fileInfo.setFilePath(convertedFile.getAbsolutePath());
                fileInfo.setFileSize(Long.valueOf(convertedFile.length()));
                try {
                    fileInfo.setInputStream((InputStream)new FileInputStream(convertedFile));
                }
                catch (FileNotFoundException e) {
                    logger.error("\u6587\u4ef6\u88ab\u5220\u9664:{}", (Object)key);
                    throw new FileStoreException("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u88ab\u5220\u9664:" + key, (Throwable)e);
                }
                return fileInfo;
            }
            logger.warn("\u60f3\u8981\u83b7\u53d6\u7684{}\u683c\u5f0f\u6587\u4ef6\u662f\u4ee5\u5206\u9875\u591a\u6587\u4ef6\u7684\u5f62\u5f0f\u4fdd\u5b58\u7684\uff0c\u8bf7\u4f7f\u7528getFilePage\u51fd\u6570\uff0c\u6307\u5b9a\u9875\u7801\u540e\u518d\u83b7\u53d6\u6587\u4ef6\u3002", (Object)outType.toString());
            return null;
        }
        throw new DocConvertException("\u4e0d\u652f\u6301\u8f6c\u6362\u8be5\u6587\u4ef6\u5230\u76ee\u6807\u7c7b\u578b\u3002\u6587\u4ef6Key=" + key + ", \u6587\u4ef6\u540d\uff1a" + fileInfo.getFileName());
    }

    public FileInfo getFilePage(String key, OutputType outType, int page, boolean autoConvert) throws FileStoreException, DocConvertException {
        FileInfo fileInfo = this.fileStore.getFile(key);
        if (fileInfo == null) {
            throw new FileStoreException("\u5728\u6587\u4ef6\u5b58\u50a8\u5e93\u4e2d\u627e\u4e0d\u5230\u6587\u4ef6\u3002Key=" + key);
        }
        String fileName = fileInfo.getFileName().toLowerCase();
        if (FilenameUtils.isExtension((String)fileName, (String[])CAN_PREVIEW_EXTS)) {
            logger.warn("\u6587\u4ef6\u53ef\u76f4\u63a5\u9884\u89c8\uff0c\u4e0d\u9700\u8981\u5206\u9875\u67e5\u770b\uff01");
            return fileInfo;
        }
        if (FilenameUtils.isExtension((String)fileName, (String[])CAN_CONVERT_EXTS)) {
            File convertedFile = DocConvertService.getConvertedPage((String)key, (OutputType)outType, (int)page);
            if (convertedFile == null) {
                if (autoConvert) {
                    DocConvertService.convert((InputStream)fileInfo.getInputStream(), (String)fileName, (String)key, (OutputType)outType);
                    convertedFile = DocConvertService.getConvertedPage((String)key, (OutputType)outType, (int)page);
                } else {
                    logger.info("{}\u6587\u4ef6\u5c1a\u672a\u88ab\u8f6c\u6362\u6210{}\u683c\u5f0f", (Object)key, (Object)outType.toString());
                    return null;
                }
            }
            fileInfo.setFilePath(convertedFile.getAbsolutePath());
            fileInfo.setFileSize(Long.valueOf(convertedFile.length()));
            try {
                fileInfo.setInputStream((InputStream)new FileInputStream(convertedFile));
            }
            catch (FileNotFoundException e) {
                logger.error("\u6587\u4ef6\u88ab\u5220\u9664:{}", (Object)key);
                throw new FileStoreException("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u88ab\u5220\u9664:" + key, (Throwable)e);
            }
            return fileInfo;
        }
        throw new DocConvertException("\u4e0d\u652f\u6301\u8f6c\u6362\u8be5\u6587\u4ef6\u5230\u76ee\u6807\u7c7b\u578b\u3002\u6587\u4ef6Key=" + key + ", \u6587\u4ef6\u540d\uff1a" + fileInfo.getFileName());
    }
}

