/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.doccenter;

import com.kdgcsoft.power.doc.convert.OutputType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConvertStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AutoConvertStrategy.class);
    private Map<String, SortedSet<OutputType>> convertDefMap = new HashMap<String, SortedSet<OutputType>>();
    private static final String[][] DEFAULT_MAP = new String[][]{{"doc", "pdf"}, {"docx", "pdf"}, {"xls", "html"}, {"xlsx", "html"}, {"ppt", "pdf"}, {"pptx", "pdf"}};

    public AutoConvertStrategy(String[][] convertMap) {
        int i = 0;
        while (i < convertMap.length) {
            String inputExt = convertMap[i][0];
            String[] outExts = convertMap[i][1].split(",");
            this.addStrategy(inputExt, outExts);
            ++i;
        }
    }

    public AutoConvertStrategy(Map<String, String> convertMap) {
        for (Map.Entry<String, String> oneStrategy : convertMap.entrySet()) {
            String inputExt = oneStrategy.getKey();
            String[] outExts = oneStrategy.getValue().split(",");
            this.addStrategy(inputExt, outExts);
        }
    }

    public void addStrategy(String inputExt, String[] outExts) {
        SortedSet<OutputType> typeList = this.convertDefMap.get(inputExt);
        if (typeList == null) {
            typeList = new TreeSet<OutputType>();
            this.convertDefMap.put(inputExt, typeList);
        }
        int j = 0;
        while (j < outExts.length) {
            String outExt = outExts[j].trim();
            OutputType outType = null;
            if ("pdf".equalsIgnoreCase(outExt)) {
                outType = OutputType.pdf;
            } else if ("html".equalsIgnoreCase(outExt)) {
                outType = OutputType.html;
            } else if ("png".equalsIgnoreCase(outExt)) {
                outType = OutputType.png;
            } else {
                logger.error("\u4e0d\u652f\u6301\u7684\u8f6c\u6362\u76ee\u6807\u6269\u5c55\u540d\uff1a{}", (Object)outExt);
            }
            if (outType != null) {
                typeList.add(outType);
            }
            ++j;
        }
    }

    public void addStrategy(String srcExtName, OutputType outType) {
        SortedSet<OutputType> typeSet = this.convertDefMap.get(srcExtName);
        if (typeSet == null) {
            typeSet = new TreeSet<OutputType>();
            this.convertDefMap.put(srcExtName, typeSet);
        }
        typeSet.add(outType);
    }

    public Collection<OutputType> getConvertStrategy(String extName) {
        return this.convertDefMap.get(extName);
    }

    public static AutoConvertStrategy createDefaultStrategy() {
        return new AutoConvertStrategy(DEFAULT_MAP);
    }
}

