/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.frame.webframe.core.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.db.dialect.DialectFactory;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.BaseDicDao;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.BaseLoggersDao;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.BaseMenuBtnDao;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.BaseMenuDao;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.BasePermissionDao;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.BaseVersionDao;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseDic;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseLoggers;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseMenu;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseMenuBtn;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BasePermission;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseVersion;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.LogicDelete;
import com.kdgcsoft.scrdc.frame.webframe.core.dao.BaseInfoDao;
import com.kdgcsoft.scrdc.frame.webframe.core.entity.BaseInfo;
import com.kdgcsoft.scrdc.frame.webframe.core.entity.StateEnum;
import com.kdgcsoft.scrdc.frame.webframe.core.exception.FrameException;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.CoreInitParams;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.EmbedDic;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.EmbedMenu;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.EmbedMenuBtn;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.EmbedNavMenu;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.EmbedTheme;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.FrameModel;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.InitParam;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.InitSql;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.Version;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.interfaces.FrameExtConfig;
import com.kdgcsoft.scrdc.frame.webframe.core.helper.MenuBtnScaner;
import com.kdgcsoft.scrdc.frame.webframe.core.helper.ScriptRunner;
import com.kdgcsoft.scrdc.frame.webframe.core.model.LoginUser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FrameService {
    private static final Logger log = LoggerFactory.getLogger(FrameService.class);
    public static final String BASE_PACKAGE = "com";
    public static final String BASE_INFO = "base_info";
    public static final String SQL_SUFFIX = "sql";
    public static final String KEY_COLUMN = "info_Key";
    public static final String KEY_INITED = "INITED";
    public static final String INITED_FLAG = "1";
    public static final String UPDATE_XML = "META-INF/update/update.xml";
    private DataSource dataSource;
    private String dbType;
    private boolean inited;
    private boolean needUpdate;
    private ConfigurableApplicationContext configurableContext;
    private BaseLoggersDao loggersDao;
    private BaseInfoDao baseInfoDao;
    private BaseMenuDao menuDao;
    private BaseMenuBtnDao menuBtnDao;
    private BaseDicDao dicDao;
    private BaseVersionDao versionDao;
    private BasePermissionDao permissionDao;
    private List<FrameExtConfig> extConfigList = new ArrayList<FrameExtConfig>();
    private Map<String, InitParam> initParamsMap = new LinkedHashMap<String, InitParam>();
    private List<InitSql> initSqlList = new ArrayList<InitSql>();
    private Map<String, List<Version>> versionMap = new HashMap<String, List<Version>>();
    private Map<String, FrameModel> modelMap = new HashMap<String, FrameModel>();
    private List<EmbedMenu> embedMenuList = new ArrayList<EmbedMenu>();
    private List<EmbedMenuBtn> embedBtnList = new ArrayList<EmbedMenuBtn>();
    private List<String> menuCodeList = new ArrayList<String>();
    private Map<String, EmbedDic> embedDicMap = new LinkedHashMap<String, EmbedDic>();
    private List<EmbedNavMenu> navList = new LinkedList<EmbedNavMenu>();
    private List<EmbedNavMenu> leftNavList = new LinkedList<EmbedNavMenu>();
    private List<EmbedNavMenu> rightNavList = new LinkedList<EmbedNavMenu>();
    private Map<String, String> shiroFilterChainMap = new HashMap<String, String>();
    private Map<String, javax.servlet.Filter> shiroFilters = new HashMap<String, javax.servlet.Filter>();
    private Map<String, Class> beetlTagMap = new HashMap<String, Class>();
    private String shiroLoginUrl;
    private Class realmClass;
    private List<EmbedTheme> themeList = new ArrayList<EmbedTheme>();
    private List<String> indexJsList = new ArrayList<String>();
    private Map<String, Boolean> permissionMap = new HashMap<String, Boolean>();

    public FrameService(DataSource dataSource, ConfigurableApplicationContext configurableContext) throws SQLException {
        this.dataSource = dataSource;
        this.configurableContext = configurableContext;
        this.dbType = DialectFactory.getDialect((DataSource)dataSource).dialectName().name().toLowerCase();
        this.loggersDao = (BaseLoggersDao)configurableContext.getBean(BaseLoggersDao.class);
        this.baseInfoDao = (BaseInfoDao)configurableContext.getBean(BaseInfoDao.class);
        this.menuDao = (BaseMenuDao)configurableContext.getBean(BaseMenuDao.class);
        this.dicDao = (BaseDicDao)configurableContext.getBean(BaseDicDao.class);
        this.menuBtnDao = (BaseMenuBtnDao)configurableContext.getBean(BaseMenuBtnDao.class);
        this.versionDao = (BaseVersionDao)configurableContext.getBean(BaseVersionDao.class);
        this.permissionDao = (BasePermissionDao)configurableContext.getBean(BasePermissionDao.class);
        this.inited = this.checkInited();
        this.scanConfigClass();
        if (this.inited) {
            // empty if block
        }
        this.loadConfig();
        if (!this.inited) {
            // empty if block
        }
        this.afterConfig();
        this.sortConfigData();
        if (this.inited) {
            this.afterInited();
        }
    }

    public void restart() {
        Class mainClass = null;
        Map classes = this.configurableContext.getBeansWithAnnotation(SpringBootApplication.class);
        for (Object o : classes.values()) {
            Class target = AopUtils.getTargetClass(o);
            mainClass = target.getSuperclass();
        }
        ApplicationArguments startargs = (ApplicationArguments)this.configurableContext.getBean(ApplicationArguments.class);
        this.configurableContext.close();
        this.configurableContext = SpringApplication.run(mainClass, (String[])startargs.getSourceArgs());
    }

    private void scanConfigClass() {
        for (Class clazz : ClassUtil.scanPackageBySuper((String)BASE_PACKAGE, FrameExtConfig.class)) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
            try {
                FrameExtConfig extConfig = (FrameExtConfig)this.configurableContext.getBean(clazz);
                this.extConfigList.add(extConfig);
            }
            catch (Exception e) {
                throw new FrameException(e.getMessage(), (Throwable)e);
            }
        }
        CollUtil.sort(this.extConfigList, Comparator.comparingInt(FrameExtConfig::order));
    }

    public void loadConfig() {
        for (FrameExtConfig extConfig : this.extConfigList) {
            List indexjs;
            List navMenuList;
            List themes;
            List embedMenus;
            List extInitParamList = extConfig.initParams();
            if (CollUtil.isNotEmpty((Collection)extInitParamList)) {
                for (InitParam initParam : extInitParamList) {
                    if (!this.initParamsMap.containsKey(initParam.getKey())) {
                        this.initParamsMap.put(initParam.getKey(), initParam);
                        continue;
                    }
                    log.error("\u521d\u59cb\u5316\u53c2\u6570\u7684key[{}]\u5df2\u7ecf\u5b58\u5728,\u8bf7\u6362\u7528\u5176\u4ed6\u7684key\u503c", (Object)initParam.getKey());
                }
            }
            if (this.checkRepeatMenu(embedMenus = extConfig.embedMenu())) {
                log.error("{} \u5305\u542b\u91cd\u590dEmbedMenu,{}\u4e2d\u7684\u6240\u6709EmbedMenu \u5c06\u4e0d\u4f1a\u52a0\u8f7d,\u8bf7\u4fee\u6539menucode", (Object)extConfig.getClass().getName());
            } else if (CollUtil.isNotEmpty((Collection)embedMenus)) {
                this.embedMenuList.addAll(embedMenus);
            }
            List dicList = extConfig.embedDic();
            if (CollUtil.isNotEmpty((Collection)dicList)) {
                for (EmbedDic dic : dicList) {
                    if (this.embedDicMap.containsKey(dic.getDicCode())) {
                        log.error("\u5185\u7f6e\u5b57\u5178\u7f16\u7801 diccode[{}]\u5df2\u7ecf\u5b58\u5728,\u8bf7\u6362\u7528\u5176\u4ed6\u7684\u503c", (Object)dic.getDicCode());
                        continue;
                    }
                    this.embedDicMap.put(dic.getDicCode(), dic);
                }
            }
            if (CollUtil.isNotEmpty((Collection)(themes = extConfig.embedTheme()))) {
                EmbedDic dic;
                dic = themes.iterator();
                while (dic.hasNext()) {
                    EmbedTheme theme = (EmbedTheme)dic.next();
                    this.themeList.add(theme);
                }
            }
            if (CollUtil.isNotEmpty((Collection)(navMenuList = extConfig.embedNavMenus()))) {
                for (EmbedNavMenu nav : navMenuList) {
                    this.navList.add(nav);
                    switch (nav.getNavType()) {
                        case RIGHT: {
                            this.rightNavList.add(nav);
                            break;
                        }
                        case LEFT: {
                            this.rightNavList.add(nav);
                        }
                    }
                }
            }
            if (CollUtil.isNotEmpty((Collection)(indexjs = extConfig.customIndexJs()))) {
                this.indexJsList.addAll(indexjs);
            }
            if (extConfig.shiroRealm() != null) {
                this.realmClass = extConfig.shiroRealm();
            }
            if (extConfig.shiroFilters() != null) {
                this.shiroFilters.putAll(extConfig.shiroFilters());
            }
            if (StrUtil.isNotEmpty((CharSequence)extConfig.shiroLoginUrl())) {
                this.shiroLoginUrl = extConfig.shiroLoginUrl();
            }
            if (MapUtil.isNotEmpty((Map)extConfig.shiroFilterChain())) {
                this.shiroFilterChainMap.putAll(extConfig.shiroFilterChain());
            }
            if (!MapUtil.isNotEmpty((Map)extConfig.beetlTag())) continue;
            this.beetlTagMap.putAll(extConfig.beetlTag());
        }
    }

    private void syncConfig() {
        if (this.inited) {
            this.syncInitParams();
            this.syncEmbedMenus();
            this.syncEmbedMenuBtns();
            this.syncEmbedDics();
        }
    }

    private void afterConfig() {
        for (FrameExtConfig extendConfig : this.extConfigList) {
            extendConfig.afterConfig(this);
        }
    }

    public void afterInited() {
        for (FrameExtConfig extendConfig : this.extConfigList) {
            extendConfig.afterInited(this);
        }
    }

    public void afterUpdated() {
        for (FrameExtConfig extendConfig : this.extConfigList) {
            extendConfig.afterUpdated(this);
        }
    }

    public void syncLogSettings() {
        if (this.inited) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            List loggerlist = this.loggersDao.selectList(null);
            for (BaseLoggers logger : loggerlist) {
                ch.qos.logback.classic.Logger log = loggerContext.getLogger(logger.getName());
                if (log == null) continue;
                if (1 == logger.getState()) {
                    log.setLevel(Level.valueOf((String)logger.getLevel()));
                    continue;
                }
                log.setLevel(null);
            }
        }
    }

    public void syncEmbedDics() {
        List dbdiclist = this.dicDao.findByLogicDelete(LogicDelete.N);
        ArrayList<BaseDic> changeList = new ArrayList<BaseDic>();
        for (final EmbedDic dic : this.embedDicMap.values()) {
            Map values = dic.getValues();
            for (final String value : values.keySet()) {
                BaseDic basedic = (BaseDic)CollUtil.findOne((Iterable)dbdiclist, (Filter)new Filter<BaseDic>(){

                    public boolean accept(BaseDic baseDic) {
                        return StrUtil.equals((CharSequence)baseDic.getDicCode(), (CharSequence)dic.getDicCode()) && StrUtil.equals((CharSequence)baseDic.getDicValue(), (CharSequence)value);
                    }
                });
                if (basedic != null) continue;
                basedic = new BaseDic();
                basedic.setDicCode(dic.getDicCode());
                basedic.setDicName(dic.getDicName());
                basedic.setDicText((String)values.get(value));
                basedic.setDicValue(value);
                basedic.setDicType(BaseDic.DicType.EMBED);
                changeList.add(basedic);
            }
        }
        for (BaseDic baseDic : changeList) {
            if (baseDic.getDicId() == null) {
                this.dicDao.insert((Object)baseDic);
                continue;
            }
            this.dicDao.updateById((Object)baseDic);
        }
    }

    public void syncEmbedMenus() {
        List menuList = this.menuDao.selectList(null);
        this.buildMenuWithDb(this.embedMenuList, menuList, 0L);
    }

    public void syncEmbedMenuBtns() {
        List btnlist = this.menuBtnDao.selectList(null);
        for (BaseMenuBtn dbbtn : btnlist) {
            if (CollUtil.findOneByField(this.embedBtnList, (String)"btnCode", (Object)dbbtn.getBtnCode()) != null) continue;
            this.menuBtnDao.deleteById((Serializable)dbbtn);
        }
        List menuList = this.menuDao.selectList(null);
        ArrayList<String> btncache = new ArrayList<String>();
        for (EmbedMenuBtn btn : this.embedBtnList) {
            String menuCode = "";
            String btnCode = btn.getBtnCode();
            String btnName = btn.getBtnName();
            if (StrUtil.isNotEmpty((CharSequence)btn.getBtnCode())) {
                menuCode = StrUtil.subBefore((CharSequence)btn.getBtnCode(), (CharSequence)".", (boolean)false);
            } else {
                log.warn("\u6309\u94ae{},\u65e0\u6cd5\u8bc6\u522b", (Object)btn.toString());
            }
            if (!StrUtil.isNotEmpty((CharSequence)menuCode) || !StrUtil.isNotEmpty((CharSequence)btnCode) || !StrUtil.isNotEmpty((CharSequence)btnName)) continue;
            if (btncache.contains(btnCode)) {
                log.warn("\u6309\u94ae{}\u6309\u94ae\u7f16\u7801\u91cd\u590d,\u4e0d\u4f1a\u91cd\u590d\u52a0\u8f7d", (Object)btn.toString());
                continue;
            }
            btncache.add(btnCode);
            this.saveMenuBtnToDb(menuList, btn);
        }
    }

    private void saveMenuBtnToDb(List<BaseMenu> menuList, EmbedMenuBtn btn) {
        String menuCode = "";
        String btnCode = btn.getBtnCode();
        String btnName = btn.getBtnName();
        if (StrUtil.isNotEmpty((CharSequence)btn.getBtnCode())) {
            menuCode = StrUtil.subBefore((CharSequence)btn.getBtnCode(), (CharSequence)".", (boolean)false);
        } else {
            log.warn("\u6309\u94ae{},\u65e0\u6cd5\u8bc6\u522b", (Object)btn.toString());
        }
        if (StrUtil.isNotEmpty((CharSequence)menuCode) && StrUtil.isNotEmpty((CharSequence)btnCode) && StrUtil.isNotEmpty((CharSequence)btnName)) {
            BaseMenu btnbelongMenu = (BaseMenu)CollUtil.findOneByField(menuList, (String)"menuCode", (Object)menuCode);
            if (btnbelongMenu != null) {
                BaseMenuBtn dbbtn = this.menuBtnDao.findByMenuCodeAndBtnCodeAndLogicDelete(menuCode, btnCode, LogicDelete.N);
                if (dbbtn != null) {
                    if (!StrUtil.equals((CharSequence)btnName, (CharSequence)dbbtn.getBtnName())) {
                        dbbtn.setBtnName(btnName);
                        this.menuBtnDao.updateById((Object)dbbtn);
                    }
                } else {
                    BaseMenuBtn newbtn = new BaseMenuBtn();
                    newbtn.setBtnName(btnName);
                    newbtn.setMenuCode(menuCode);
                    newbtn.setBtnCode(btnCode);
                    this.menuBtnDao.insert((Object)newbtn);
                }
            } else {
                String[] parts = btnCode.split("\\.");
                StringBuilder code = new StringBuilder();
                Long pid = 0L;
                for (String part : parts) {
                    code.append(code.length() == 0 ? part : "." + part);
                    String curCode = code.toString();
                    BasePermission p = this.permissionDao.findFirstByPermCode(curCode);
                    if (null == p) {
                        p = new BasePermission();
                    }
                    p.setPermCode(curCode);
                    p.setPermName(curCode.equals(btnCode) ? btnName : "");
                    p.setPermPid(pid);
                    p.setCreateTime(new Date());
                    if (p.getPermId() == null) {
                        this.permissionDao.insert((Object)p);
                    } else {
                        this.permissionDao.updateById((Object)p);
                    }
                    pid = p.getPermId();
                }
            }
        } else {
            log.warn("\u6309\u94ae{}\u5b58\u5728\u5c5e\u6027\u7f3a\u5931,\u4e0d\u4f1a\u52a0\u8f7d", (Object)btn.toString());
        }
    }

    private void buildMenuWithDb(List<EmbedMenu> menuList, List<BaseMenu> dbmenuList, long pid) {
        for (EmbedMenu embedMenu : menuList) {
            BaseMenu dbmenu = (BaseMenu)CollUtil.findOneByField(dbmenuList, (String)"menuCode", (Object)embedMenu.getMenuCode());
            if (dbmenu != null) {
                if (!StrUtil.equals((CharSequence)embedMenu.getUrl(), (CharSequence)dbmenu.getMenuUrl())) {
                    dbmenu.setMenuUrl(embedMenu.getUrl());
                    this.menuDao.updateById((Object)dbmenu);
                }
            } else {
                dbmenu = new BaseMenu();
                dbmenu.setMenuCode(embedMenu.getMenuCode());
                dbmenu.setMenuUrl(embedMenu.getUrl());
                dbmenu.setMenuName(embedMenu.getName());
                dbmenu.setMenuIco(embedMenu.getIcon());
                dbmenu.setOrderNo(Integer.valueOf(embedMenu.getOrder()));
                dbmenu.setMenuType(BaseMenu.MenuType.EMBED);
                dbmenu.setMenuState(Integer.valueOf(1));
                dbmenu.setOpenType(Integer.valueOf(0));
                dbmenu.setMenuPid(Long.valueOf(pid));
                this.menuDao.insert((Object)dbmenu);
            }
            if (!CollUtil.isNotEmpty((Collection)embedMenu.getChildren())) continue;
            this.buildMenuWithDb(embedMenu.getChildren(), dbmenuList, dbmenu.getMenuId());
        }
    }

    private boolean checkRepeatMenu(List<EmbedMenu> menulist) {
        if (CollUtil.isEmpty(menulist)) {
            return false;
        }
        Iterator<EmbedMenu> iterator = menulist.iterator();
        if (iterator.hasNext()) {
            EmbedMenu childmenu = iterator.next();
            if (this.menuCodeList.contains(childmenu.getMenuCode())) {
                log.error("\u5185\u7f6e\u83dc\u5355\u7f16\u7801[{}]\u91cd\u590d,\u8bf7\u6362\u7528\u5176\u4ed6\u7684menuCode", (Object)childmenu.getMenuCode());
                return true;
            }
            this.menuCodeList.add(childmenu.getMenuCode());
            return this.checkRepeatMenu(childmenu.getChildren());
        }
        return false;
    }

    private void sortEmbedMenus(List<EmbedMenu> menulist) {
        if (CollUtil.isNotEmpty(menulist)) {
            CollUtil.sort(menulist, Comparator.comparingInt(EmbedMenu::getOrder));
            for (EmbedMenu menu : menulist) {
                this.sortEmbedMenus(menu.getChildren());
            }
        }
    }

    private void loadInitSql() {
        String basepath = "META-INF/init/";
        basepath = basepath + this.dbType;
        List resourcelist = ResourceUtil.getResources((String)basepath);
        for (URL url : resourcelist) {
            if ("file".equals(url.getProtocol())) {
                List fileList = FileUtil.loopFiles((File)new File(url.getFile()));
                for (File file : fileList) {
                    if (!SQL_SUFFIX.equalsIgnoreCase(FileUtil.extName((File)file))) continue;
                    InitSql sql = new InitSql();
                    sql.setSqlName(file.getName());
                    sql.setPathType("file");
                    sql.setSqlPath(file.getAbsolutePath());
                    sql.setDownloadPath(Base64.encode((CharSequence)file.getAbsolutePath()));
                    this.initSqlList.add(sql);
                }
                continue;
            }
            if (!"jar".equals(url.getProtocol())) continue;
            try {
                JarFile jarFile = URLUtil.getJarFile((URL)url);
                Object object = null;
                try {
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry jarEntry = jarEntries.nextElement();
                        String resourceName = jarEntry.getName();
                        if (!StrUtil.startWithIgnoreCase((CharSequence)resourceName, (CharSequence)basepath) || !StrUtil.endWithIgnoreCase((CharSequence)resourceName, (CharSequence)".sql")) continue;
                        File jarfile = new File(jarFile.getName());
                        InitSql sql = new InitSql();
                        sql.setSqlName(StrUtil.subAfter((CharSequence)resourceName, (CharSequence)"/", (boolean)true));
                        sql.setPathType("jar");
                        sql.setSqlPath(jarfile.getName() + "/" + resourceName);
                        sql.setDownloadPath(Base64.encode((CharSequence)resourceName));
                        this.initSqlList.add(sql);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (jarFile == null) continue;
                    if (object != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            catch (Exception e) {
                log.error("Loading init SQL Error:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void syncInitParams() {
        List dbinfolist = this.baseInfoDao.selectList(null);
        for (InitParam params : this.initParamsMap.values()) {
            BaseInfo dbinfo = (BaseInfo)CollUtil.findOneByField((Iterable)dbinfolist, (String)"infoKey", (Object)params.getKey());
            if (dbinfo == null || dbinfo.getInfoValue() == null || dbinfo.getInfoValue().length <= 0) continue;
            params.setValue(dbinfo.getInfoValue());
            params.setStrValue(dbinfo.getInfoValueStr());
        }
    }

    private void sortConfigData() {
        this.sortEmbedMenus(this.embedMenuList);
        CollUtil.sort(this.themeList, Comparator.comparingInt(EmbedTheme::getOrder));
        CollUtil.sort(this.leftNavList, Comparator.comparingInt(EmbedNavMenu::getOrder));
        CollUtil.sort(this.rightNavList, Comparator.comparingInt(EmbedNavMenu::getOrder));
    }

    private void loadMenuBtns() {
        this.loadEmbedMenuBtns(this.embedMenuList);
        this.loadMenuBtnFormFile();
    }

    private void loadEmbedMenuBtns(List<EmbedMenu> menulist) {
        for (EmbedMenu menu : menulist) {
            if (CollUtil.isNotEmpty((Collection)menu.getBtnList())) {
                this.embedBtnList.addAll(menu.getBtnList());
            }
            if (!CollUtil.isNotEmpty((Collection)menu.getChildren())) continue;
            this.loadEmbedMenuBtns(menu.getChildren());
        }
    }

    public void loadPermission() {
        this.permissionMap.clear();
        List menuList = this.menuDao.findByLogicDeleteOrderByOrderNo(LogicDelete.N);
        for (BaseMenu menu : menuList) {
            if (menu.getMenuState() != 1) continue;
            this.permissionMap.put(menu.getMenuCode(), true);
        }
        List btnList = this.menuBtnDao.selectList(null);
        for (BaseMenuBtn btn : btnList) {
            if (btn.getBtnState() != StateEnum.Y) continue;
            this.permissionMap.put(btn.getBtnCode(), true);
        }
    }

    public boolean existPermission(String permissionCode) {
        return this.permissionMap.containsKey(permissionCode);
    }

    private void loadMenuBtnFormFile() {
        this.embedBtnList.addAll(MenuBtnScaner.getAllMenuBtns());
    }

    public boolean hasPermission(LoginUser user, String btnCode) {
        if (StrUtil.equals((CharSequence)this.getParamStr("PERMISSION_LEVEL"), (CharSequence)"2")) {
            if (user.isSuperAdmin() || !this.existPermission(btnCode)) {
                return true;
            }
            return user.getPermissions().contains(btnCode);
        }
        return true;
    }

    public void refreshConfig() {
        try {
            this.syncConfig();
            this.afterConfig();
            this.sortConfigData();
        }
        catch (Exception e) {
            throw new FrameException(e.getMessage(), (Throwable)e);
        }
    }

    public void scanMenuBtnByMenuCode(String menuCode) {
        if (StrUtil.isNotEmpty((CharSequence)menuCode)) {
            List menuList = this.menuDao.selectList(null);
            for (EmbedMenuBtn btn : this.embedBtnList) {
                String btnmenuCode = StrUtil.subBefore((CharSequence)btn.getBtnCode(), (CharSequence)".", (boolean)false);
                if (!StrUtil.equals((CharSequence)menuCode, (CharSequence)btnmenuCode)) continue;
                this.saveMenuBtnToDb(menuList, btn);
            }
        }
    }

    private boolean checkInited() {
        return true;
    }

    private void loadFrameModelFormXML() {
        List updatexmls = ResourceUtil.getResources((String)UPDATE_XML);
        for (URL url : updatexmls) {
            FrameModel framemodel = this.readModelFormXML(url);
            if (framemodel == null) continue;
            this.modelMap.put(framemodel.getModelCode(), framemodel);
        }
    }

    public void syncModelVersion() {
        for (FrameExtConfig extConfig : this.extConfigList) {
            FrameModel model = this.modelMap.get(extConfig.modelCode());
            if (model == null || !CollUtil.isNotEmpty((Collection)model.getVersions())) continue;
            model.setModeOrder(extConfig.order());
            this.versionMap.put(extConfig.modelCode(), model.getVersions());
        }
        ArrayList<BaseVersion> updateversionList = new ArrayList<BaseVersion>();
        for (String modelkey : this.versionMap.keySet()) {
            List<Version> modelversion = this.versionMap.get(modelkey);
            FrameModel framemodel = this.modelMap.get(modelkey);
            if (!CollUtil.isNotEmpty(modelversion)) continue;
            List dbmodelversions = this.versionDao.findByModelCode(modelkey);
            for (Version version : modelversion) {
                BaseVersion dbversion = (BaseVersion)CollUtil.findOneByField((Iterable)dbmodelversions, (String)"versionNo", (Object)version.getVersionNo());
                if (dbversion == null) {
                    BaseVersion newverion = new BaseVersion();
                    newverion.setModelCode(modelkey);
                    newverion.setVersionNo(version.getVersionNo());
                    newverion.setTitle(version.getTitle());
                    newverion.setScript(version.getScript());
                    newverion.setScriptUrl(this.getVersionScriptUrl(framemodel, version));
                    newverion.setDescription(version.getDescription());
                    newverion.setState(BaseVersion.VersionState.UN_EXECUTED);
                    newverion.setModelOrder(framemodel.getModeOrder());
                    updateversionList.add(newverion);
                    continue;
                }
                if (StrUtil.equals((CharSequence)dbversion.getDescription(), (CharSequence)version.getDescription()) && StrUtil.equals((CharSequence)dbversion.getTitle(), (CharSequence)version.getTitle()) && StrUtil.equals((CharSequence)dbversion.getScript(), (CharSequence)version.getScript())) continue;
                dbversion.setDescription(version.getDescription());
                dbversion.setTitle(version.getTitle());
                dbversion.setScript(version.getScript());
                dbversion.setScriptUrl(this.getVersionScriptUrl(framemodel, version));
                updateversionList.add(dbversion);
            }
        }
        for (BaseVersion version : updateversionList) {
            if (version.getVersionId() == null) {
                this.versionDao.insert((Object)version);
                continue;
            }
            this.versionDao.updateById((Object)version);
        }
    }

    private String getVersionScriptUrl(FrameModel model, Version version) {
        if (model == null || StrUtil.isEmpty((CharSequence)version.getScript())) {
            return null;
        }
        String urlstr = model.getBaseUrl() + "/META-INF/update/" + version.getVersionNo() + "/" + this.dbType + "/" + version.getScript();
        try {
            URL scriptUrl = new URL(urlstr);
            return scriptUrl.toString();
        }
        catch (MalformedURLException e) {
            log.error(model.getModelCode() + "[" + version.getVersionNo() + "]\u5bf9\u5e94\u7684\u811a\u672c\u6587\u4ef6" + version.getScript() + "\u672a\u627e\u5230,\u67e5\u627e\u8def\u5f84\u4e3a:" + urlstr, (Throwable)e);
            return null;
        }
    }

    private FrameModel readModelFormXML(URL xmlurl) {
        try {
            String basePath = StrUtil.subBefore((CharSequence)xmlurl.toString(), (CharSequence)"/META-INF", (boolean)true);
            Document document = XmlUtil.readXML((InputStream)xmlurl.openStream());
            Element root = XmlUtil.getRootElement((Document)document);
            if ("FrameModel".equals(root.getTagName())) {
                FrameModel frameModel = new FrameModel();
                String modelCode = root.getAttribute("modelCode");
                boolean autoUpdate = Boolean.valueOf(root.getAttribute("autoUpdate"));
                Integer order = NumberUtil.parseInt((String)root.getAttribute("order"));
                frameModel.setModelCode(modelCode);
                frameModel.setAutoUpdate(autoUpdate);
                frameModel.setBaseUrl(basePath);
                frameModel.setModeOrder(order == null ? Integer.MAX_VALUE : order);
                Element versionsEL = XmlUtil.getElement((Element)root, (String)"versions");
                for (Element versionnode : XmlUtil.getElements((Element)versionsEL, (String)"version")) {
                    if (StrUtil.isNotEmpty((CharSequence)versionnode.getAttribute("versionNo"))) {
                        Version version = new Version();
                        version.setVersionNo(versionnode.getAttribute("versionNo"));
                        Element titlenode = XmlUtil.getElement((Element)versionnode, (String)"title");
                        version.setTitle(titlenode == null ? "" : titlenode.getTextContent());
                        Element scriptnode = XmlUtil.getElement((Element)versionnode, (String)"script");
                        version.setScript(scriptnode == null ? "" : scriptnode.getTextContent());
                        Element descriptionnode = XmlUtil.getElement((Element)versionnode, (String)"description");
                        version.setDescription(descriptionnode == null ? "" : descriptionnode.getTextContent());
                        frameModel.addVersion(version);
                        continue;
                    }
                    log.error("\u914d\u7f6e\u6587\u4ef6\u51fa\u73b0\u5173\u952e\u5c5e\u6027\u7f3a\u5931:versions->version\u7f3a\u5931\u5c5e\u6027versionNo,\u6587\u4ef6\u8def\u5f84:" + xmlurl.getPath());
                }
                return frameModel;
            }
            return null;
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6" + xmlurl.getPath() + "\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public void checkUpdateState() {
        int updatecount = this.versionDao.countByState(BaseVersion.VersionState.UN_EXECUTED);
        this.needUpdate = updatecount > 0;
    }

    public void updateBackground() {
        if (this.needUpdate) {
            block9: {
                ArrayList dbversionList = new ArrayList();
                for (FrameModel frameModel : this.modelMap.values()) {
                    if (!frameModel.isAutoUpdate()) continue;
                    dbversionList.addAll(this.versionDao.findByModelCodeAndState(frameModel.getModelCode(), BaseVersion.VersionState.UN_EXECUTED));
                }
                CollUtil.sort(dbversionList, Comparator.comparingInt(BaseVersion::getModelOrder).thenComparing((o1, o2) -> StrUtil.compareVersion((CharSequence)o1.getVersionNo(), (CharSequence)o2.getVersionNo())));
                if (CollUtil.isNotEmpty(dbversionList)) {
                    log.info("\u68c0\u6d4b\u5230\u9700\u8981\u81ea\u52a8\u66f4\u65b0\u7684\u6a21\u5757,\u5f00\u59cb\u81ea\u52a8\u66f4\u65b0");
                    Connection connection = null;
                    try {
                        connection = this.dataSource.getConnection();
                        connection.setAutoCommit(false);
                        for (BaseVersion version : dbversionList) {
                            log.info("\u5f00\u59cb\u66f4\u65b0\u7248\u672c:{}({}),\u66f4\u65b0\u811a\u672c:{}", new Object[]{version.getModelCode(), version.getVersionNo(), version.getScript()});
                            if (StrUtil.isNotEmpty((CharSequence)version.getScript())) {
                                URL scripturl = new URL(version.getScriptUrl());
                                log.info("\u53d1\u73b0\u66f4\u65b0\u811a\u672c:{}", (Object)scripturl);
                                ScriptRunner sqlrunner = new ScriptRunner(connection);
                                sqlrunner.setAutoCommit(false);
                                sqlrunner.setStopOnError(true);
                                log.info("\u5f00\u59cb\u6267\u884c\u811a\u672c:{}", (Object)scripturl);
                                sqlrunner.runScript((Reader)URLUtil.getReader((URL)scripturl, (Charset)Charset.forName("UTF-8")));
                                log.info("\u6267\u884c\u811a\u672c\u5b8c\u6210:{}", (Object)scripturl);
                            }
                            version.setState(BaseVersion.VersionState.EXECUTED);
                            log.info("\u7248\u672c\u66f4\u65b0\u5b8c\u6210,\u66f4\u65b0\u7248\u672c\u72b6\u6001");
                        }
                        log.info("\u6240\u6709\u7248\u672c\u5168\u90e8\u66f4\u65b0\u5b8c\u6210,\u5f00\u59cb\u63d0\u4ea4\u4e8b\u52a1");
                        connection.commit();
                        connection.close();
                        dbversionList.forEach(dbversion -> {
                            if (dbversion.getVersionId() == null) {
                                this.versionDao.insert(dbversion);
                            } else {
                                this.versionDao.updateById(dbversion);
                            }
                        });
                        log.info("\u672c\u6b21\u66f4\u65b0\u5168\u90e8\u5b8c\u6210");
                    }
                    catch (Exception exception) {
                        log.error("\u81ea\u52a8\u66f4\u65b0\u7248\u672c\u51fa\u9519,\u5f00\u59cb\u8fdb\u884c\u4e8b\u52a1\u56de\u6eda", (Throwable)exception);
                        if (connection == null) break block9;
                        try {
                            connection.rollback();
                            connection.close();
                            log.error("\u4e8b\u52a1\u5df2\u56de\u6eda,\u672c\u6b21\u66f4\u65b0\u7ed3\u675f,\u66f4\u65b0\u7ed3\u679c:\u5931\u8d25");
                        }
                        catch (SQLException e1) {
                            log.error(e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            }
            this.checkUpdateState();
        }
    }

    public boolean isInited() {
        return this.inited;
    }

    public Map<String, InitParam> getInitParamsMap() {
        return this.initParamsMap;
    }

    public Map<String, List<InitParam>> getGroupedInitParams() {
        LinkedHashMap<String, List<InitParam>> groupmap = new LinkedHashMap<String, List<InitParam>>();
        for (InitParam paramsBean : this.initParamsMap.values()) {
            if (groupmap.containsKey(paramsBean.getGroup())) {
                ((List)groupmap.get(paramsBean.getGroup())).add(paramsBean);
                continue;
            }
            groupmap.put(paramsBean.getGroup(), CollUtil.newLinkedList((Object[])new InitParam[]{paramsBean}));
        }
        return groupmap;
    }

    public List<InitSql> getInitSqlList() {
        return this.initSqlList;
    }

    public InitParam getParam(String key) {
        return this.initParamsMap.get(key);
    }

    public String getParamStr(String key) {
        return this.initParamsMap.get(key).getStrValue();
    }

    public String getParamStr(CoreInitParams key) {
        return this.initParamsMap.get(key.name()).getStrValue();
    }

    public byte[] getParamByte(CoreInitParams key) {
        return this.initParamsMap.get(key.name()).getValue();
    }

    public byte[] getParamByte(String key) {
        return this.initParamsMap.get(key).getValue();
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }

    public boolean isNeedUpdate() {
        return this.needUpdate;
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }

    public Map<String, List<Version>> getVersionMap() {
        return this.versionMap;
    }

    public List<EmbedMenu> getEmbedMenuList() {
        return this.embedMenuList;
    }

    public List<EmbedDic> getEmbedDicList() {
        return CollUtil.newArrayList(this.embedDicMap.values());
    }

    public List<EmbedTheme> getThemeList() {
        return this.themeList;
    }

    public Map<String, String> getShiroFilterChainMap() {
        return this.shiroFilterChainMap;
    }

    public Class getRealmClass() {
        return this.realmClass;
    }

    public Map<String, javax.servlet.Filter> getShiroFilters() {
        return this.shiroFilters;
    }

    public String getShiroLoginUrl() {
        return this.shiroLoginUrl;
    }

    public List<EmbedNavMenu> getLeftNavList() {
        return this.leftNavList;
    }

    public List<EmbedNavMenu> getRightNavList() {
        return this.rightNavList;
    }

    public EmbedNavMenu getNavMenu(String navId) {
        return this.getNavMenu(this.navList, navId);
    }

    private EmbedNavMenu getNavMenu(List<EmbedNavMenu> navlist, String navId) {
        if (CollUtil.isNotEmpty(navlist)) {
            for (EmbedNavMenu nav : navlist) {
                if (StrUtil.equals((CharSequence)navId, (CharSequence)nav.getId())) {
                    return nav;
                }
                EmbedNavMenu subresult = this.getNavMenu(nav.getChildren(), navId);
                if (subresult == null) continue;
                return subresult;
            }
        }
        return null;
    }

    public boolean existMenuBtn(String btnCode) {
        EmbedMenuBtn btn = (EmbedMenuBtn)CollUtil.findOneByField(this.embedBtnList, (String)"btnCode", (Object)btnCode);
        return btn != null;
    }

    public List<String> getIndexJsList() {
        return this.indexJsList;
    }

    public <T> T getBean(Class<T> requiredType) {
        return (T)this.configurableContext.getBean(requiredType);
    }

    public Map<String, Class> getBeetlTagMap() {
        return this.beetlTagMap;
    }

    public void setBeetlTagMap(Map<String, Class> beetlTagMap) {
        this.beetlTagMap = beetlTagMap;
    }
}

