/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.frame.webframe.core.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.scrdc.frame.webframe.core.cache.CacheHelper;
import com.kdgcsoft.scrdc.frame.webframe.core.controller.BaseController;
import com.kdgcsoft.scrdc.frame.webframe.core.model.GridPage;
import com.kdgcsoft.scrdc.frame.webframe.core.model.GridPageRequest;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/core/cache-monitor"})
public class CacheMonitorController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(CacheMonitorController.class);
    @Autowired(required=false)
    private CacheManager cacheManager;

    @RequestMapping(value={"/index"})
    @ResponseBody
    public ModelAndView index() {
        return this.renderView("/core/cacheMonitor.html");
    }

    @RequestMapping(value={"/names"})
    @ResponseBody
    public GridPage getCacheNames(GridPageRequest request) {
        ArrayList cacheNames = new ArrayList(this.cacheManager.getCacheNames());
        Collections.sort(cacheNames);
        List cacheNamesList = cacheNames.stream().map(s -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", (String)s);
            return map;
        }).collect(Collectors.toList());
        int from = (request.getPage() - 1) * request.getRows();
        int end = Math.min(from + request.getRows(), 1000);
        if (end > cacheNames.size()) {
            end = cacheNames.size();
        }
        GridPage gridPage = new GridPage();
        gridPage.setTotal((long)Math.min(cacheNames.size(), 1000));
        if (from > cacheNames.size()) {
            gridPage.setRows(Collections.emptyList());
        } else {
            gridPage.setRows(cacheNamesList.subList(from, end));
        }
        return gridPage;
    }

    @RequestMapping(value={"/keys"})
    @ResponseBody
    public GridPage getCacheKeys(GridPageRequest request, String cacheName) {
        List keys = CacheHelper.getCacheKeys((CacheManager)this.cacheManager, (String)cacheName);
        Collections.sort(keys);
        List keysList = keys.stream().map(s -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", (String)s);
            return map;
        }).collect(Collectors.toList());
        int from = (request.getPage() - 1) * request.getPage();
        int end = Math.min(from + request.getRows(), 1000);
        if (end > keysList.size()) {
            end = keysList.size();
        }
        GridPage gridPage = new GridPage();
        gridPage.setTotal((long)Math.min(keysList.size(), 1000));
        if (from > keysList.size()) {
            gridPage.setRows(Collections.emptyList());
        } else {
            gridPage.setRows(keysList.subList(from, end));
        }
        return gridPage;
    }

    @RequestMapping(value={"/content"})
    @ResponseBody
    public JsonResult getCacheContent(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        try {
            return JsonResult.success((String)"\u64cd\u4f5c\u6210\u529f!", (Object)JSON.toJSONString((Object)cache.get((Object)key).get(), (boolean)true));
        }
        catch (Exception e) {
            logger.error(String.format("getCacheContent error,cacheName: %s,key: %s", cacheName, key), (Throwable)e);
            return JsonResult.error((String)"\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/clear"})
    @ResponseBody
    public JsonResult clearCache(String cacheName, String key) {
        try {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (StrUtil.isEmpty((CharSequence)key)) {
                cache.clear();
            } else {
                cache.evict((Object)key);
            }
            return JsonResult.success();
        }
        catch (Exception e) {
            logger.error(String.format("clearCache error,cacheName: %s,key: %s", cacheName, key), (Throwable)e);
            return JsonResult.error((String)"\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u7f13\u5b58\u5217\u8868\uff01");
        }
    }

    @RequestMapping(value={"/check"})
    @ResponseBody
    public JsonResult checkCache() {
        if (CacheHelper.checkCacheManager((CacheManager)this.cacheManager)) {
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/search-key"})
    @ResponseBody
    public JsonResult searchKey(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        try {
            cache.get((Object)key).get();
            return JsonResult.success();
        }
        catch (Exception e) {
            logger.error(String.format("searchKey error,cacheName: %s,key: %s", cacheName, key), (Throwable)e);
            return JsonResult.error((String)("\u952e\u540d:" + key + "\u4e0d\u5b58\u5728"));
        }
    }
}

