/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.cas;

import cn.hutool.core.map.MapUtil;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.config.shiro.XzzfCasFilter;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.interfaces.FrameExtConfig;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.shiro.cas.CasFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroCasConfig
implements FrameExtConfig {
    @Autowired
    private ShiroCasProperties shiroCasProperties;
    @Autowired
    private XzzfProperties xzzfProperties;

    public String modelCode() {
        return "shiro-cas";
    }

    public Map<String, String> shiroFilterChain() {
        HashMap map = MapUtil.newHashMap((boolean)true);
        if (this.shiroCasProperties.isCasEnable()) {
            map.put("/toIndex", "casFilter");
            map.put("/logout", "logoutFilter");
            map.put("/quit", "logoutFilter");
            map.put("/error", "anon");
        }
        return map;
    }

    public Map<String, Filter> shiroFilters() {
        HashMap map = MapUtil.newHashMap();
        if (this.shiroCasProperties.isCasEnable()) {
            CasFilter casFilter = new CasFilter();
            if (this.xzzfProperties.isUniqueUser()) {
                casFilter = new XzzfCasFilter();
            }
            casFilter.setFailureUrl("/error");
            map.put("casFilter", casFilter);
            LogoutFilter logoutFilter = new LogoutFilter();
            if (this.xzzfProperties.isFrontEnable()) {
                logoutFilter.setRedirectUrl(this.shiroCasProperties.getCasServerUrl() + "logout?service=" + this.shiroCasProperties.getSuccessUrl());
            } else {
                logoutFilter.setRedirectUrl(this.shiroCasProperties.getCasServerUrl() + "logout?service=" + this.shiroCasProperties.getService());
            }
            map.put("logoutFilter", logoutFilter);
        }
        return map;
    }

    public String shiroLoginUrl() {
        String url = this.shiroCasProperties.getCasServerUrl() + "login?service=" + this.shiroCasProperties.getService() + "toIndex";
        return this.shiroCasProperties.isCasEnable() ? url : null;
    }

    @Bean
    @ConditionalOnProperty(name={"shiro.cas.casEnable"}, havingValue="true")
    public FilterRegistrationBean singleSignOutFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setName("singleSignOutFilter");
        SingleSignOutFilter singleSignOutFilter = new SingleSignOutFilter();
        singleSignOutFilter.setIgnoreInitConfiguration(true);
        bean.setFilter((Filter)singleSignOutFilter);
        bean.addUrlPatterns(new String[]{"/*"});
        bean.setEnabled(true);
        bean.setOrder(0);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(name={"shiro.cas.casEnable"}, havingValue="true")
    public ServletListenerRegistrationBean<SingleSignOutHttpSessionListener> sessionListenerWithMetrics() {
        ServletListenerRegistrationBean listenerRegBean = new ServletListenerRegistrationBean();
        listenerRegBean.setListener((EventListener)new SingleSignOutHttpSessionListener());
        return listenerRegBean;
    }
}

