/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.frame.webframe.core.config.shiro;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.config.shiro.UniqueUserFilter;
import com.kdgcsoft.jt.xzzf.common.config.shiro.XzzfUniqueUserFilter;
import com.kdgcsoft.jt.xzzf.common.config.shiro.XzzfUserFilter;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.SuperAdminRealm;
import com.kdgcsoft.scrdc.frame.webframe.core.service.FrameService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategy;
import org.apache.shiro.authc.pam.AuthenticationStrategy;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    @Autowired
    FrameService frameService;
    @Autowired
    ConfigurableApplicationContext configurableContex;
    @Autowired
    private ShiroCasProperties shiroCasProperties;
    @Autowired
    private XzzfProperties xzzfProperties;

    @Bean
    public SuperAdminRealm superAdminRealm() {
        return new SuperAdminRealm();
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityManager securityManager(SessionManager sessionManager) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setAuthenticator((Authenticator)this.modularRealmAuthenticator());
        ArrayList<Object> realms = new ArrayList<Object>();
        if (this.shiroCasProperties.isAdminEnable()) {
            realms.add(this.superAdminRealm());
        }
        if (this.frameService.getRealmClass() != null) {
            realms.add((Realm)this.configurableContex.getBean(this.frameService.getRealmClass()));
        }
        securityManager.setRealms(realms);
        securityManager.setSubjectFactory(this.subjectFactory());
        return securityManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public SubjectFactory subjectFactory() {
        DefaultWebSubjectFactory subjectFactory = new DefaultWebSubjectFactory();
        return subjectFactory;
    }

    @Bean
    public ModularRealmAuthenticator modularRealmAuthenticator() {
        ModularRealmAuthenticator modularRealmAuthenticator = new ModularRealmAuthenticator();
        modularRealmAuthenticator.setAuthenticationStrategy((AuthenticationStrategy)new AtLeastOneSuccessfulStrategy());
        return modularRealmAuthenticator;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        Map<String, Filter> filters = this.frameService.getShiroFilters();
        filters.putAll(this.getFilters());
        shiroFilterFactoryBean.setFilters(filters);
        HashMap map = MapUtil.newHashMap((boolean)true);
        map.put("/static/**", "anon");
        map.put("/webjars/**", "anon");
        map.put("/style/**", "anon");
        map.put("/js/**", "anon");
        map.put("/plugins/**", "anon");
        map.put("/theme/**", "anon");
        map.put("/init/**", "anon");
        map.put("/401", "anon");
        map.put("/logout", "logout");
        map.put("/quit", "logout");
        map.put("/xtbadocument/documentTree", "anon");
        map.putAll(this.frameService.getShiroFilterChainMap());
        if (this.shiroCasProperties.isShiroEnable()) {
            if (this.xzzfProperties.isFrontEnable()) {
                if (this.xzzfProperties.isUniqueUser()) {
                    map.put("/**", "xzzfUniqueUser");
                } else {
                    map.put("/**", "xzzfUser");
                }
            } else if (this.xzzfProperties.isUniqueUser()) {
                map.put("/**", "uniqueUser");
            } else {
                map.put("/**", "user");
            }
        } else {
            map.put("/**", "anon");
        }
        if (StrUtil.isNotEmpty((CharSequence)this.frameService.getShiroLoginUrl())) {
            shiroFilterFactoryBean.setLoginUrl(this.frameService.getShiroLoginUrl());
        } else {
            shiroFilterFactoryBean.setLoginUrl("/login");
        }
        shiroFilterFactoryBean.setSuccessUrl(this.shiroCasProperties.getSuccessUrl());
        shiroFilterFactoryBean.setUnauthorizedUrl("/login");
        shiroFilterFactoryBean.setFilterChainDefinitionMap((Map)map);
        shiroFilterFactoryBean.setUnauthorizedUrl("/401");
        return shiroFilterFactoryBean;
    }

    private Map<String, Filter> getFilters() {
        HashMap<String, Filter> filterMap = new HashMap<String, Filter>();
        filterMap.put("xzzfUser", (Filter)new XzzfUserFilter());
        filterMap.put("xzzfUniqueUser", (Filter)new XzzfUniqueUserFilter());
        filterMap.put("uniqueUser", (Filter)new UniqueUserFilter());
        return filterMap;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    @Bean
    public DefaultWebSessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionIdUrlRewritingEnabled(false);
        return sessionManager;
    }

    @Bean
    public static DefaultAdvisorAutoProxyCreator getDefaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator creator = new DefaultAdvisorAutoProxyCreator();
        creator.setUsePrefix(true);
        return creator;
    }
}

