/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.XmlUtil;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.BusinessException;
import com.kdgcsoft.jt.xzzf.common.util.FileUtil;
import com.kdgcsoft.jt.xzzf.common.util.HttpRequest;
import com.kdgcsoft.jt.xzzf.common.util.HttpRespons;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SzzjSignUtil {
    private static final Logger log = LoggerFactory.getLogger(SzzjSignUtil.class);
    private static XzzfProperties xzzfProperties;
    public static final String BASE_PATH = "template";
    public static final String COMMON_PATH = "pdf";

    public static byte[] stampSignForPdf(String signAct, String filter, String tempPath) {
        String fullPath = SzzjSignUtil.getTempFileFullPath(tempPath);
        System.out.println("=========\u8bd5\u7b7e\u6a21\u677f\u8def\u5f84:" + fullPath);
        if (BeanUtils.isNotEmpty(fullPath)) {
            if (new File(fullPath).exists()) {
                byte[] stampPdf = FileUtil.getBytesByFile(fullPath);
                return SzzjSignUtil.stampForPdf(stampPdf, signAct, filter, 1);
            }
            throw new BusinessException("\u8bd5\u7b7e\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        throw new BusinessException("\u8bd5\u7b7e\u6a21\u677f\u8def\u5f84\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] stampForPdf(byte[] stampPdf, String signAct, String filter, int pdfPage) {
        log.info("======================>\u7535\u5b50\u7b7e\u7ae0\u63a5\u53e3\u5730\u5740:" + SzzjSignUtil.getSignUrlFromProp());
        if (BeanUtils.isNotEmpty(stampPdf)) {
            try {
                String base64pdf = Base64.encodeBase64String((byte[])stampPdf);
                String pdfUrl = SzzjSignUtil.sealAutoZfPdf(base64pdf, signAct, filter, pdfPage);
                if (BeanUtils.isNotEmpty(pdfUrl)) {
                    pdfUrl = pdfUrl.replace("ESS", "yzyy");
                    stampPdf = SzzjSignUtil.getPdf(pdfUrl);
                    return stampPdf;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                return stampPdf;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sealAutoZfPdf(String base64pdf, String signAct, String filter, int pdfPage) {
        String result = null;
        try {
            String xmlStr = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><SEAL_DOC_REQUEST>    <BASE_DATA>        <SYS_ID>jtyst</SYS_ID>        <SYS_PWD>jtyst20201010</SYS_PWD>    </BASE_DATA>    <META_DATA>        <IS_MERGER>false</IS_MERGER>    </META_DATA>    <FILE_LIST>        <TREE_NODE>            <FILE_NO>test.pdf</FILE_NO>            <CJ_TYPE>BASE64</CJ_TYPE>            <MODEL_NAME>" + base64pdf + "</MODEL_NAME>            <IS_MERGER>false</IS_MERGER>            <IS_CODEBAR>false</IS_CODEBAR>            <DOC_TYPE>pdf</DOC_TYPE>            <RULE_TYPE>1</RULE_TYPE>            <RULE_LIST>                <RULE_NODE>                    <RULE_INFO>AUTO_ADD:0," + pdfPage + ",230,345,255," + filter + ")|(4,</RULE_INFO>                    <SEAL_CODE>" + signAct + "</SEAL_CODE>                </RULE_NODE>            </RULE_LIST>        </TREE_NODE>    </FILE_LIST></SEAL_DOC_REQUEST>";
            HashMap<String, String> parms = new HashMap<String, String>();
            parms.put("xmlStr", xmlStr);
            HttpRequest httpRequest = new HttpRequest();
            HttpRespons httpRespons = null;
            httpRespons = httpRequest.sendPost(SzzjSignUtil.getSignUrlFromProp() + "sealAutoPdfZF", parms);
            result = httpRespons.getContent();
            if (SzzjSignUtil.getSignUrlFromProp().contains("59.203.5.104")) {
                Map map = XmlUtil.xmlToMap((String)result);
                Map map2 = (Map)map.get("FILE_LIST");
                Map map3 = (Map)map2.get("FILE");
                result = (String)map3.get("FILE_URL");
            }
            System.out.println("==========\u5408\u6210\u5b8c\u7684pdf\u63a5\u53e3\u5730\u5740\uff1a" + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return result;
        }
    }

    public static byte[] getPdf(String fileUrl) throws IOException {
        if (SzzjSignUtil.getSignUrlFromProp().contains("xzzf-webService")) {
            fileUrl = SzzjSignUtil.getSignUrlFromProp() + "pdfForByte?fileUrl=" + fileUrl;
        }
        System.out.println("==========pdf\u63a5\u53e3\u5730\u5740\uff1a" + fileUrl);
        URL url = new URL(fileUrl);
        InputStream is = url.openStream();
        DataInputStream dataInputStream = new DataInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] chs = new byte[1024];
        int len = 0;
        while ((len = dataInputStream.read(chs)) != -1) {
            bos.write(chs, 0, len);
        }
        bos.flush();
        bos.close();
        is.close();
        dataInputStream.close();
        byte[] bytes = bos.toByteArray();
        System.out.println("==========\u7535\u5b50\u7b7e\u7ae0\u63a5\u53e3\u8fd4\u56depdf\u5927\u5c0f\uff1a" + bytes.length);
        return bytes;
    }

    @Autowired
    public void setXzzfProperties(XzzfProperties xzzfProperties) {
        SzzjSignUtil.xzzfProperties = xzzfProperties;
    }

    public static String getSignUrlFromProp() {
        return xzzfProperties.getSignUrl();
    }

    public static String getTempFileFullPath(String filePath) {
        String tempCommonPath = xzzfProperties.isTempFileMode() ? new File(System.getProperty("user.dir")) + File.separator + BASE_PATH + File.separator + COMMON_PATH + File.separator : SzzjSignUtil.class.getClassLoader().getResource("").getPath() + BASE_PATH + File.separator + COMMON_PATH + File.separator;
        return tempCommonPath + filePath;
    }
}

