/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public static String getActiveProfile() {
        return applicationContext.getEnvironment().getActiveProfiles()[0];
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(String beanName) {
        try {
            return (T)applicationContext.getBean(beanName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getDubboBean(Class<T> requiredType) {
        ReferenceAnnotationBeanPostProcessor dubboContext = (ReferenceAnnotationBeanPostProcessor)applicationContext.getBean(ReferenceAnnotationBeanPostProcessor.class);
        Collection referenceBeans = dubboContext.getReferenceBeans();
        for (ReferenceBean referenceBean : referenceBeans) {
            Class objectType = referenceBean.getObjectType();
            if (objectType != requiredType || !StrUtil.isEmpty((CharSequence)referenceBean.getVersion())) continue;
            try {
                return (T)referenceBean.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T> T getDubboBean(Class<T> requiredType, String version) {
        if (StrUtil.isEmpty((CharSequence)version)) {
            return SpringContextHolder.getDubboBean(requiredType);
        }
        ReferenceAnnotationBeanPostProcessor dubboContext = (ReferenceAnnotationBeanPostProcessor)applicationContext.getBean(ReferenceAnnotationBeanPostProcessor.class);
        Collection referenceBeans = dubboContext.getReferenceBeans();
        for (ReferenceBean referenceBean : referenceBeans) {
            Class objectType = referenceBean.getObjectType();
            if (objectType != requiredType || !referenceBean.getVersion().equals(version)) continue;
            try {
                return (T)referenceBean.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T> T getBean(Class<T> requiredType) {
        try {
            return (T)applicationContext.getBean(requiredType);
        }
        catch (Exception e) {
            return null;
        }
    }
}

