/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.util.regex.Pattern;

public class RegexUtils {
    public static boolean regexEmail(String email) {
        String regex = "\\w+@\\w+\\.[a-z]+(\\.[a-z]+)?";
        return Pattern.matches(regex, email.trim());
    }

    public static boolean regexIdCard(String idCard) {
        String regex = "[1-9]\\d{13,16}[xX0-9]";
        return Pattern.matches(regex, idCard.trim());
    }

    public static boolean regexUrl(String url) {
        String regex = "^(?=^.{3,255}$)(http(s)?:\\/\\/)?(www\\.)?[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+(:\\d+)*(\\/\\w+\\.\\w+)*$";
        return Pattern.matches(regex, url.trim());
    }

    public static boolean regexNumber(String num) {
        String regex = "^-?\\d+$";
        return Pattern.matches(regex, num.trim());
    }

    public static boolean regexFloat(String num) {
        String regex = "^-?\\d+\\.?\\d+$";
        return Pattern.matches(regex, num.trim());
    }

    public static boolean regexPositive(String str) {
        String regex = "^[1-9]\\d*$";
        return Pattern.matches(regex, str.trim());
    }

    public static boolean regexDecimal(String str) {
        String regex = "^(([1-9]{1}\\d*)|(0{1}))(\\.\\d{1,2})?$";
        return Pattern.matches(regex, str.trim());
    }

    public static boolean regexTel(String str) {
        String regexMobile = "^1(3|4|5|6|7|8|9)\\d{9}$";
        String regexTel1 = "^((0\\d{2,3})-)(\\d{7,8})(-(\\d{3,}))?$";
        String regexTel2 = "^(\\d{7,8})(-(\\d{3,}))?$/";
        boolean result1 = Pattern.matches(regexMobile, str.trim());
        boolean result2 = Pattern.matches(regexTel1, str.trim());
        boolean result3 = Pattern.matches(regexTel2, str.trim());
        return result1 || result2 || result3;
    }

    public static boolean regexDate(String str) {
        String rexpDate1 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$";
        return Pattern.matches(rexpDate1, str.trim());
    }

    public static boolean regexYearAndMonth(String str) {
        String rexpDate1 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[123456789]|1[012]))))$";
        return Pattern.matches(rexpDate1, str.trim());
    }

    public static boolean regexLongitude(String str) {
        String regex = "^(\\-|\\+)?(((\\d|[1-9]\\d|1[0-7]\\d|0{1,3})\\.\\d{0,15})|(\\d|[1-9]\\d|1[0-7]\\d|0{1,3})|180\\.0{0,15}|180)$";
        return Pattern.matches(regex, str.trim());
    }

    public static boolean regexLaitude(String str) {
        String regex = "^(\\-|\\+)?([0-8]?\\d{1}\\.\\d{0,15}|90\\.0{0,15}|[0-8]?\\d{1}|90)$";
        return Pattern.matches(regex, str.trim());
    }

    public static boolean regexFax(String str) {
        String regex = "^(?:\\d{3,4}-)?\\d{7,8}(?:-\\d{1,6})?$";
        return Pattern.matches(regex, str.trim());
    }

    public static void main(String[] args) {
        String content = "admin";
        byte[] key = SecureUtil.generateKey((String)SymmetricAlgorithm.AES.getValue()).getEncoded();
        SymmetricCrypto aes = new SymmetricCrypto(SymmetricAlgorithm.AES, key);
        String encryptHex = aes.encryptHex(content);
        String decryptStr = aes.decryptStr(encryptHex);
        System.out.println("===============key:" + key);
        System.out.println("===============encryptHex:" + encryptHex);
        System.out.println("===============decryptStr:" + decryptStr);
    }
}

