/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import com.kdgcsoft.jt.xzzf.common.util.FtpUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgToPdfUtil {
    private static String IMAGE_PDF_PATH = "/event/upload/xzzf-xtba/";
    private static final Logger logger = LoggerFactory.getLogger(ImgToPdfUtil.class);

    public static File Pdf(ArrayList<String> imageUrllist, String mOutputPdfFileName) throws IOException, DocumentException {
        Document doc = new Document(PageSize.A4, 0.0f, 0.0f, 1.0f, 0.0f);
        PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(mOutputPdfFileName));
        doc.open();
        String imagePath = "";
        String imageName = "";
        ByteArrayOutputStream out = null;
        for (int i = 0; i < imageUrllist.size(); ++i) {
            doc.newPage();
            imagePath = IMAGE_PDF_PATH;
            imageName = imageUrllist.get(i);
            String str = imageName.substring(1, 12);
            String str2 = imageName.substring(12, imageName.length());
            out = new ByteArrayOutputStream();
            FtpUtil.downLoad(imagePath + str, str2, out);
            byte[] bytes = out.toByteArray();
            Image png1 = Image.getInstance((byte[])bytes);
            float heigth = png1.getHeight();
            float width = png1.getWidth();
            int percent = ImgToPdfUtil.getPercent2(heigth, width);
            png1.setAlignment(1);
            png1.scalePercent((float)(percent + 3));
            doc.add((Element)png1);
        }
        doc.close();
        if (out != null) {
            out.close();
        }
        File mOutputPdfFile = new File(mOutputPdfFileName);
        logger.info("\u6587\u4ef6\u5927\u5c0f=" + mOutputPdfFile.length());
        if (mOutputPdfFile.exists()) {
            logger.info("\u6587\u4ef6\u5b58\u653e\u4f4d\u7f6e=" + mOutputPdfFileName);
        } else {
            logger.info("\u6587\u4ef6\u65b0\u5efa");
            mOutputPdfFile.createNewFile();
        }
        return mOutputPdfFile;
    }

    public static int getPercent(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = h > w ? 297.0f / h * 100.0f : 210.0f / w * 100.0f;
        p = Math.round(p2);
        return p;
    }

    public static int getPercent2(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = 530.0f / w * 100.0f;
        p = Math.round(p2);
        return p;
    }

    public boolean imgOfPdf(String imgUrl, String pdfUrl, String pdfName) throws IOException, DocumentException {
        ArrayList<String> imageUrllist = new ArrayList<String>();
        String[] imgUrls = imgUrl.split(",");
        for (int i = 0; i < imgUrls.length; ++i) {
            logger.info("\u56fe\u7247\u540d\u79f0=" + imgUrls[i]);
            imageUrllist.add(imgUrls[i]);
        }
        File file = ImgToPdfUtil.Pdf(imageUrllist, pdfUrl + File.separator + pdfName);
        return true;
    }
}

