/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.util;

import com.kdgcsoft.jt.xzzf.common.util.HttpRespons;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String defaultContentEncoding = Charset.defaultCharset().name();

    public HttpRespons sendGet(String urlString) throws IOException {
        return this.send(urlString, "GET", null, null);
    }

    public HttpRespons sendGet(String urlString, Map<String, String> paramsMap) throws IOException {
        return this.send(urlString, "GET", paramsMap, null);
    }

    public HttpRespons sendGet(String urlString, Map<String, String> paramsMap, Map<String, String> propertysMap) throws IOException {
        return this.send(urlString, "GET", paramsMap, propertysMap);
    }

    public HttpRespons sendPost(String urlString) throws IOException {
        return this.send(urlString, "POST", null, null);
    }

    public HttpRespons sendPost(String urlString, Map<String, String> paramsMap) throws IOException {
        return this.send(urlString, "POST", paramsMap, null);
    }

    public HttpRespons sendPost(String urlString, Map<String, String> paramsMap, Map<String, String> propertysMap) throws IOException {
        return this.send(urlString, "POST", paramsMap, propertysMap);
    }

    private HttpRespons send(String urlString, String method, Map<String, String> parametersMap, Map<String, String> propertysMap) throws IOException {
        HttpURLConnection urlConnection = null;
        if (method.equalsIgnoreCase("GET") && parametersMap != null) {
            StringBuffer param = new StringBuffer();
            int i = 0;
            for (String key : parametersMap.keySet()) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append(key).append("=").append(URLEncoder.encode(parametersMap.get(key), "UTF-8"));
                ++i;
            }
            urlString = urlString + param;
        }
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        URL url = new URL(urlString);
        urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod(method);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setConnectTimeout(30000);
        urlConnection.setReadTimeout(30000);
        if (propertysMap != null) {
            for (String key : propertysMap.keySet()) {
                urlConnection.addRequestProperty(key, propertysMap.get(key));
            }
        }
        if (method.equalsIgnoreCase("POST") && parametersMap != null) {
            StringBuffer param = new StringBuffer();
            for (String key : parametersMap.keySet()) {
                param.append("&");
                param.append(key).append("=").append(URLEncoder.encode(parametersMap.get(key), "UTF-8"));
            }
            urlConnection.getOutputStream().write(param.toString().getBytes());
            urlConnection.getOutputStream().flush();
            urlConnection.getOutputStream().close();
        }
        return this.makeContent(urlString, urlConnection);
    }

    private HttpRespons makeContent(String urlString, HttpURLConnection urlConnection) throws IOException {
        HttpRespons httpResponse = new HttpRespons();
        try {
            int code = urlConnection.getResponseCode();
            InputStream in = code == 200 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, this.defaultContentEncoding));
            httpResponse.contentCollection = new Vector();
            StringBuffer temp = new StringBuffer();
            String line = bufferedReader.readLine();
            while (line != null) {
                httpResponse.contentCollection.add(line);
                temp.append(line).append("\r\n");
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            String ecod = urlConnection.getContentEncoding();
            if (ecod == null) {
                ecod = this.defaultContentEncoding;
            }
            httpResponse.urlString = urlString;
            httpResponse.defaultPort = urlConnection.getURL().getDefaultPort();
            httpResponse.file = urlConnection.getURL().getFile();
            httpResponse.host = urlConnection.getURL().getHost();
            httpResponse.path = urlConnection.getURL().getPath();
            httpResponse.port = urlConnection.getURL().getPort();
            httpResponse.protocol = urlConnection.getURL().getProtocol();
            httpResponse.query = urlConnection.getURL().getQuery();
            httpResponse.ref = urlConnection.getURL().getRef();
            httpResponse.userInfo = urlConnection.getURL().getUserInfo();
            httpResponse.content = temp.toString();
            httpResponse.contentEncoding = ecod;
            httpResponse.code = urlConnection.getResponseCode();
            httpResponse.message = urlConnection.getResponseMessage();
            httpResponse.contentType = urlConnection.getContentType();
            httpResponse.method = urlConnection.getRequestMethod();
            httpResponse.connectTimeout = urlConnection.getConnectTimeout();
            httpResponse.readTimeout = urlConnection.getReadTimeout();
            this.logger.info("response.urlString is :{}", (Object)httpResponse.urlString);
            this.logger.info("response.content is :{}", (Object)httpResponse.content);
            HttpRespons httpRespons = httpResponse;
            return httpRespons;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public String getDefaultContentEncoding() {
        return this.defaultContentEncoding;
    }

    public void setDefaultContentEncoding(String defaultContentEncoding) {
        this.defaultContentEncoding = defaultContentEncoding;
    }
}

