/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpMode;
import com.kdgcsoft.jt.xzzf.common.util.PropertyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FtpUtil.class);
    private static String FTP_HOST = PropertyUtil.getProperty("ftpHost");
    private static int PORT = Integer.parseInt(PropertyUtil.getProperty("ftpPort"));
    private static String USER = PropertyUtil.getProperty("ftpUser");
    private static String PWD = PropertyUtil.getProperty("ftpPwd");
    private static String BASE_PATH = PropertyUtil.getProperty("ftpPath");

    public static Ftp getInstance() {
        Ftp ftp = new Ftp(FTP_HOST, PORT, USER, PWD);
        ftp.setMode(FtpMode.Passive);
        LOG.info("FTP\u4f7f\u7528\u88ab\u52a8\u6a21\u5f0f\uff01");
        return ftp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean upload(String path, String fileName, InputStream in) {
        try (Ftp ftp = FtpUtil.getInstance();){
            ftp.cd(BASE_PATH);
            boolean upload = ftp.upload(BASE_PATH + path, fileName, in);
            LOG.info("ftp\u662f\u5426\u4e0a\u4f20\u6210\u529f\uff1a" + upload);
            boolean bl = upload;
            return bl;
        }
        catch (IOException e) {
            LOG.error("FTP\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean upload(String basePath, String path, String fileName, InputStream in) {
        try (Ftp ftp = FtpUtil.getInstance();){
            ftp.cd(basePath);
            boolean bl = ftp.upload(basePath + path, fileName, in);
            return bl;
        }
        catch (IOException e) {
            LOG.error("FTP\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean downLoad(String basePath, String path, String fileName, OutputStream out) {
        try (Ftp ftp = FtpUtil.getInstance();){
            ftp.cd(BASE_PATH);
            ftp.download(basePath + path, fileName, out);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("FTP\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean downLoad(String path, String fileName, OutputStream out) {
        try (Ftp ftp = FtpUtil.getInstance();){
            ftp.cd(BASE_PATH);
            ftp.download(BASE_PATH + path, fileName, out);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("FTP\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existFile(String pathPath) {
        try (Ftp ftp = FtpUtil.getInstance();){
            ftp.cd(BASE_PATH);
            ftp.existFile(BASE_PATH + pathPath);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

