/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.token;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.kdgcsoft.jt.xzzf.common.token.SimpleToken;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenUtil {
    @Autowired
    RedisUtil redisUtil;

    public String generateTokenId() {
        return IDUtil.uuid();
    }

    public void touchToken(SimpleToken simpleToken) {
        simpleToken.touch();
        this.redisUtil.set("token_ydzf_" + simpleToken.getId(), JSONUtil.toJsonStr((Object)simpleToken));
    }

    public void expireToken(SimpleToken simpleToken) {
        simpleToken.expire();
        this.redisUtil.set("token_ydzf_" + simpleToken.getId(), JSONUtil.toJsonStr((Object)simpleToken));
    }

    public void clearToken(SimpleToken simpleToken) {
        this.redisUtil.delete("token_ydzf_" + simpleToken.getId());
    }

    public List<SimpleToken> getYdzfTokens() {
        ArrayList<Object> simpleTokens = new ArrayList<Object>();
        Set<String> keys = this.redisUtil.keys("token_ydzf_*");
        if (CollUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                simpleTokens.add(JSONUtil.toBean((String)this.redisUtil.get(key), SimpleToken.class));
            }
        }
        return Collections.unmodifiableList(simpleTokens);
    }

    public List<SimpleToken> getZfgsTokens() {
        ArrayList<Object> simpleTokens = new ArrayList<Object>();
        Set<String> keys = this.redisUtil.keys("token_zfgs_*");
        if (CollUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                simpleTokens.add(JSONUtil.toBean((String)this.redisUtil.get(key), SimpleToken.class));
            }
        }
        return Collections.unmodifiableList(simpleTokens);
    }

    public List<SimpleToken> getTokens() {
        ArrayList<Object> simpleTokens = new ArrayList<Object>();
        Set<String> keys = this.redisUtil.keys("token_*");
        if (CollUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                simpleTokens.add(JSONUtil.toBean((String)this.redisUtil.get(key), SimpleToken.class));
            }
        }
        return Collections.unmodifiableList(simpleTokens);
    }
}

