/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.rest;

import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private int code;
    private boolean status;
    private String message;
    private T data;
    private String loginSuccess;

    public static <T> Result result(boolean flag) {
        if (flag) {
            return Result.success(null);
        }
        return Result.fail("");
    }

    public static <T> Result msg(String msg) {
        return Result.result(ResultCode.SUCCESS, true, msg, null);
    }

    public static <T> Result success(T data) {
        return Result.result(ResultCode.SUCCESS, true, null, data);
    }

    public static <T> Result success(T data, String msg) {
        return Result.result(ResultCode.SUCCESS, true, msg, data);
    }

    public static <T> Result fail() {
        return Result.result(ResultCode.FAIL, false, null, null);
    }

    public static <T> Result fail(String msg) {
        return Result.result(ResultCode.FAIL, false, msg, null);
    }

    public static <T> Result fail(T data, String msg) {
        return Result.result(ResultCode.FAIL, false, msg, data);
    }

    public static <T> Result fail(ResultCode code) {
        return Result.result(code, false, null, null);
    }

    public static <T> Result fail(ResultCode code, String msg) {
        return Result.result(code, false, msg, null);
    }

    public static <T> Result result(ResultCode code, boolean status, String message, T data) {
        String msg = code.getMsg();
        if (BeanUtils.isNotEmpty(message)) {
            msg = message;
        }
        return new Result<T>(code.getCode(), status, msg, data, null);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public String getLoginSuccess() {
        return this.loginSuccess;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setLoginSuccess(String loginSuccess) {
        this.loginSuccess = loginSuccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.isStatus() != other.isStatus()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$loginSuccess = this.getLoginSuccess();
        String other$loginSuccess = other.getLoginSuccess();
        return !(this$loginSuccess == null ? other$loginSuccess != null : !this$loginSuccess.equals(other$loginSuccess));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + (this.isStatus() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $loginSuccess = this.getLoginSuccess();
        result = result * 59 + ($loginSuccess == null ? 43 : $loginSuccess.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", status=" + this.isStatus() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", loginSuccess=" + this.getLoginSuccess() + ")";
    }

    public Result(int code, boolean status, String message, T data, String loginSuccess) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.data = data;
        this.loginSuccess = loginSuccess;
    }
}

