/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.rabbit.zfry;

import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import javax.annotation.Resource;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ZfksRabbitConfig {
    @Resource
    private XzzfProperties xzzfProperties;
    public static final String TOPIC_EXCHANGE = "topic.kdgc.exchange";
    public static final String ROUTING_KEY_ZXKS = "topic.zfry.zfks.zxks";
    public static final String ROUTING_KEY_SJTJ = "topic.zfry.zfks.sjtj";
    public static final String ROUTING_KEY_CJJS = "topic.zfry.zfks.cjjs";

    @Bean
    public Queue sjtjQueue() {
        return new Queue(ROUTING_KEY_SJTJ);
    }

    @Bean
    public Queue cjjsQueue() {
        return new Queue(ROUTING_KEY_CJJS);
    }

    @Bean
    public Queue zxksQueue() {
        return new Queue(ROUTING_KEY_ZXKS);
    }

    @Bean
    TopicExchange exchange() {
        return new TopicExchange(TOPIC_EXCHANGE);
    }

    @Bean
    Binding bindingExchangeMessageSjtj() {
        return BindingBuilder.bind((Queue)this.sjtjQueue()).to(this.exchange()).with(ROUTING_KEY_SJTJ);
    }

    @Bean
    Binding bindingExchangeMessageCjjs() {
        return BindingBuilder.bind((Queue)this.cjjsQueue()).to(this.exchange()).with(ROUTING_KEY_CJJS);
    }

    @Bean
    Binding bindingExchangeMessageZxks() {
        return BindingBuilder.bind((Queue)this.zxksQueue()).to(this.exchange()).with(ROUTING_KEY_ZXKS);
    }
}

