/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.online;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.kdgcsoft.jt.xzzf.common.entity.OnLineUser;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnLineUserService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ShiroCasProperties shiroCasProperties;
    private Integer active = 24;

    public void setSessionTgt(String sessionId, String st) {
        this.logger.info("setSessionTgt\uff1a{}\uff0c{}", (Object)sessionId, (Object)st);
        String tgt = HttpUtil.get((String)(this.shiroCasProperties.getCasServerUrl() + "getTgt.do?serviceTicketId=" + st));
        this.redisUtil.setEx("session_" + sessionId + "_" + ShiroKit.getUser().getUserName(), tgt, this.active.intValue(), TimeUnit.HOURS);
    }

    public String getSessionTgt(String sessionId) {
        this.logger.info("getSessionTgt\uff1a{}", (Object)sessionId);
        return this.redisUtil.get("session_" + sessionId + "_" + ShiroKit.getUser().getUserName());
    }

    public OnLineUser getCurrentOnlineUser() {
        String casTgt = this.redisUtil.get("token_web_" + ShiroKit.getUser().getUserName());
        if (casTgt != null) {
            return (OnLineUser)JSONUtil.toBean((String)casTgt, OnLineUser.class);
        }
        return new OnLineUser();
    }

    public boolean checkSessionTgt(String sessionId) {
        OnLineUser onLineUser;
        String clientTgt = this.getSessionTgt(sessionId);
        return StrUtil.equals((CharSequence)clientTgt, (CharSequence)(onLineUser = this.getCurrentOnlineUser()).getTgt()) && StrUtil.equals((CharSequence)"0", (CharSequence)onLineUser.getStatus());
    }

    public List<OnLineUser> getOnLineUsers() {
        ArrayList<OnLineUser> list = new ArrayList<OnLineUser>();
        Set<String> keys = this.redisUtil.keys("token_web_*");
        for (String key : keys) {
            OnLineUser onLineUser = (OnLineUser)JSONUtil.toBean((String)this.redisUtil.get(key), OnLineUser.class);
            if (!"0".equals(onLineUser.getStatus())) continue;
            list.add(onLineUser);
        }
        return list;
    }

    public boolean forceLogout(String userName) {
        try {
            String casTgt = this.redisUtil.get("token_web_" + userName);
            if (casTgt != null) {
                OnLineUser onLineUser = (OnLineUser)JSONUtil.toBean((String)casTgt, OnLineUser.class);
                onLineUser.setStatus("1");
                this.redisUtil.setEx("token_web_" + userName, JSONUtil.toJsonStr((Object)onLineUser), this.active.intValue(), TimeUnit.HOURS);
                this.logger.info("\u5f3a\u5236\u4e0b\u7ebf\u6210\u529f\uff01forceLogout\uff1a{}", (Object)userName);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5f3a\u5236\u4e0b\u7ebf\u5931\u8d25\uff01forceLogout\uff1a{}", (Object)userName);
            return false;
        }
    }

    public boolean forceLogoutCas(String tgt) {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("ticketGrantingTicketId", tgt);
        String s = HttpUtil.post((String)(this.shiroCasProperties.getCasServerUrl() + "onLineUserLogout.do"), parms);
        return "success".equals(s);
    }
}

