/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.log.factory;

import com.kdgcsoft.jt.xzzf.common.enums.OperateType;
import com.kdgcsoft.jt.xzzf.common.log.entity.ErrorLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.LoginLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.OperateLog;
import com.kdgcsoft.jt.xzzf.common.log.factory.LogFactory;
import com.kdgcsoft.jt.xzzf.common.log.service.DefaultLogServiceImpl;
import com.kdgcsoft.jt.xzzf.common.log.service.LogService;
import com.kdgcsoft.jt.xzzf.common.util.SpringContextHolder;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRunableFactory {
    private static Logger logger = LoggerFactory.getLogger(LogManager.class);
    private static LogService logService;

    public static Runnable operateLog(String mode, String des, OperateType type, String className, String method, Object[] args, Object result, String userId, String ip, String subSysId) {
        return () -> {
            try {
                OperateLog operateLog = LogFactory.createOperateLog(mode, des, type, className, method, args, null, userId, ip, subSysId);
                logService.insertOperateLog(operateLog);
            }
            catch (Exception e) {
                logger.error("\u64cd\u4f5c\u65e5\u5fd7\u7ebf\u7a0b\u8bb0\u5f55\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            }
        };
    }

    public static Runnable loginLog(String userId, String userName, String ip, String browser, String subSysId) {
        return () -> {
            try {
                LoginLog loginLog = LogFactory.createLoginLog(userId, userName, ip, browser, subSysId);
                logService.insertLoginLog(loginLog);
            }
            catch (Exception e) {
                logger.error("\u767b\u5f55\u65e5\u5fd7\u7ebf\u7a0b\u8bb0\u5f55\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            }
        };
    }

    public static Runnable errorLogin(String userId, String className, String method, Object[] args, String errMsg, String subSysId) {
        return () -> {
            try {
                ErrorLog errorLog = LogFactory.createErrorLog(userId, className, method, args, errMsg, subSysId);
                logService.insertErrorLog(errorLog);
            }
            catch (Exception e) {
                logger.error("\u5f02\u5e38\u65e5\u5fd7\u7ebf\u7a0b\u8bb0\u5f55\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            }
        };
    }

    static {
        LogService bean = SpringContextHolder.getBean(LogService.class);
        logService = bean == null ? new DefaultLogServiceImpl() : bean;
    }
}

