/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.log.aop;

import com.kdgcsoft.jt.xzzf.common.annotation.Log;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.enums.OperateType;
import com.kdgcsoft.jt.xzzf.common.log.AsyncLog;
import com.kdgcsoft.jt.xzzf.common.log.factory.LogRunableFactory;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.IPUtil;
import com.kdgcsoft.jt.xzzf.common.util.SysUtils;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogAop {
    @Autowired
    private XzzfProperties xzzfProperties;

    @Pointcut(value="@annotation(com.kdgcsoft.jt.xzzf.common.annotation.Log)")
    private void logAop() {
    }

    @AfterReturning(pointcut="logAop()", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, Object result) {
        if (this.xzzfProperties.isLogEnable()) {
            this.handleLog(joinPoint, result);
        }
    }

    @AfterThrowing(value="execution(public * com.kdgcsoft..*.*controller..*.*(..))", throwing="e")
    @ResponseBody
    public void exception(JoinPoint joinPoint, Exception e) {
        if (this.xzzfProperties.isLogEnable()) {
            this.errorLog(joinPoint, e);
        }
    }

    private void handleLog(JoinPoint joinPoint, Object jsonResult) {
        Log log = this.getAnnotationLog(joinPoint);
        if (log != null) {
            ProceedingJoinPoint point = (ProceedingJoinPoint)joinPoint;
            Signature signature = point.getSignature();
            MethodSignature methodSignature = (MethodSignature)signature;
            String className = methodSignature.getDeclaringTypeName();
            String methodName = methodSignature.getName();
            Object[] argsArr = this.createArgsObj(point);
            OperateType type = log.type();
            String model = log.model();
            String des = log.des();
            SysUser user = SysUtils.getCurUser();
            String userId = user != null ? user.getUserId() : "";
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String ip = IPUtil.getIpAddress(request);
            String subSysId = BeanUtils.isNotEmpty(this.xzzfProperties.getSubSysKey()) ? this.xzzfProperties.getSubSysKey() : "";
            AsyncLog.getInstance().executeLog(LogRunableFactory.operateLog(model, des, type, className, methodName, argsArr, jsonResult, userId, ip, subSysId));
        }
    }

    private void errorLog(JoinPoint joinPoint, Exception e) {
        ProceedingJoinPoint point = (ProceedingJoinPoint)joinPoint;
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        String className = methodSignature.getDeclaringTypeName();
        String methodName = methodSignature.getName();
        Object[] argsArr = this.createArgsObj(point);
        String errMsg = this.errMsg(e);
        SysUser user = SysUtils.getCurUser();
        String userId = user != null ? user.getUserId() : "";
        String subSysId = BeanUtils.isNotEmpty(this.xzzfProperties.getSubSysKey()) ? this.xzzfProperties.getSubSysKey() : "";
        AsyncLog.getInstance().executeLog(LogRunableFactory.errorLogin(userId, className, methodName, argsArr, errMsg, subSysId));
    }

    private Log getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(Log.class);
        }
        return null;
    }

    private HashMap[] createArgsObj(ProceedingJoinPoint point) {
        Signature signature = point.getSignature();
        Object[] args = point.getArgs();
        MethodSignature methodSignature = (MethodSignature)signature;
        String[] parameterNames = methodSignature.getParameterNames();
        HashMap[] argsArr = new HashMap[parameterNames.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            HashMap<String, Object> arg = new HashMap<String, Object>();
            arg.put(parameterNames[i], args[i]);
            argsArr[i] = arg;
        }
        return argsArr;
    }

    private String errMsg(Exception error) {
        return "error_class\uff1a" + error.getClass().getName() + " error_msg " + error.getMessage();
    }
}

