/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.file.controller;

import cn.hutool.core.date.DateUtil;
import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.file.entity.FileParamsVo;
import com.kdgcsoft.jt.xzzf.common.file.util.FileUtil;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.BusinessException;
import com.kdgcsoft.jt.xzzf.common.util.FtpUtil;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.power.fileconverter.FileConverterException;
import com.kdgcsoft.power.fileconverter.FileConverterService;
import com.kdgcsoft.power.fileconverter.FileConverterSettings;
import com.kdgcsoft.power.fileconverter.Office2PdfEngineType;
import com.kdgcsoft.power.fileconverter.OutputType;
import com.kdgcsoft.power.fileconverter.StorageType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/file"})
public class FileServletController {
    private static final Logger log = LogManager.getLogger(FileServletController.class);
    @Resource
    private XzzfProperties xzzfProperties;

    @PostMapping(value={"/uploadFile"})
    public Result uploadFile(@RequestParam(value="file") MultipartFile file, FileParamsVo entity) throws IOException {
        if (BeanUtils.isNotEmpty(this.xzzfProperties.getModelCode())) {
            boolean uploadFile;
            AttachmentVo dbEntity = new AttachmentVo();
            dbEntity.setId(IDUtil.uuid());
            dbEntity.setOldFileName(file.getOriginalFilename());
            dbEntity.setFileType(file.getContentType().substring(0, file.getContentType().lastIndexOf("/")));
            dbEntity.setFileSuffix(dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf(".") + 1));
            String savePath = "/event/upload/" + this.xzzfProperties.getModelCode() + "/";
            if (BeanUtils.isNotEmpty(entity)) {
                boolean verify = FileUtil.verifyFileAccept(entity.getAccepts(), dbEntity.getFileSuffix());
                if (!verify) {
                    return Result.fail("\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                }
                if (BeanUtils.isNotEmpty(entity.getAttachType())) {
                    savePath = savePath + entity.getAttachType() + "/";
                }
                if (entity.isAttachByDate()) {
                    savePath = savePath + DateUtil.format((Date)new Date(), (String)"yyyy") + "/" + DateUtil.format((Date)new Date(), (String)"MM") + "/" + DateUtil.format((Date)new Date(), (String)"dd") + "/";
                }
                dbEntity.setFilePubPath(savePath);
            }
            if (dbEntity.getOldFileName().contains(".")) {
                if (entity.isUseOldName()) {
                    dbEntity.setNewFileName(dbEntity.getOldFileName());
                    dbEntity.setFilePath(savePath + dbEntity.getOldFileName());
                } else {
                    String newFileName = dbEntity.getId() + dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf("."));
                    dbEntity.setNewFileName(newFileName);
                    dbEntity.setFilePath(savePath + newFileName);
                }
            }
            if (uploadFile = FtpUtil.upload(savePath, dbEntity.getNewFileName(), file.getInputStream())) {
                System.out.println("\u9644\u4ef6\u7684\u76f8\u5173\u4fe1\u606f:" + dbEntity.toString());
                return Result.success(dbEntity);
            }
            return Result.fail("\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        return Result.fail("\u5b50\u7cfb\u7edf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @PostMapping(value={"/uploadFileList"})
    public Result uploadFileList(@RequestParam(value="files") MultipartFile[] files, FileParamsVo entity) throws IOException {
        ArrayList<AttachmentVo> list = new ArrayList<AttachmentVo>();
        for (MultipartFile file : files) {
            AttachmentVo dbEntity;
            if (BeanUtils.isNotEmpty(this.xzzfProperties.getModelCode())) {
                boolean uploadFile;
                dbEntity = new AttachmentVo();
                dbEntity.setId(IDUtil.uuid());
                dbEntity.setOldFileName(file.getOriginalFilename());
                dbEntity.setFileType(file.getContentType().substring(0, file.getContentType().lastIndexOf("/")));
                dbEntity.setFileSuffix(dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf(".") + 1));
                String savePath = "/event/upload/" + this.xzzfProperties.getModelCode() + "/";
                if (BeanUtils.isNotEmpty(entity)) {
                    boolean verify = FileUtil.verifyFileAccept(entity.getAccepts(), dbEntity.getFileSuffix());
                    if (!verify) {
                        return Result.fail("\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                    }
                    if (BeanUtils.isNotEmpty(entity.getAttachType())) {
                        savePath = savePath + entity.getAttachType() + "/";
                    }
                    if (entity.isAttachByDate()) {
                        savePath = savePath + DateUtil.format((Date)new Date(), (String)"yyyy") + "/" + DateUtil.format((Date)new Date(), (String)"MM") + "/" + DateUtil.format((Date)new Date(), (String)"dd") + "/";
                    }
                    dbEntity.setFilePubPath(savePath);
                }
                if (dbEntity.getOldFileName().contains(".")) {
                    if (entity.isUseOldName()) {
                        dbEntity.setNewFileName(dbEntity.getOldFileName());
                        dbEntity.setFilePath(savePath + dbEntity.getOldFileName());
                    } else {
                        String newFileName = dbEntity.getId() + dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf("."));
                        dbEntity.setNewFileName(newFileName);
                        dbEntity.setFilePath(savePath + newFileName);
                    }
                }
                if (!(uploadFile = FtpUtil.upload(savePath, dbEntity.getNewFileName(), file.getInputStream()))) {
                    return Result.fail("\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25");
                }
            } else {
                return Result.fail("\u5b50\u7cfb\u7edf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            System.out.println("\u9644\u4ef6\u7684\u76f8\u5173\u4fe1\u606f:" + dbEntity.toString());
            list.add(dbEntity);
        }
        return Result.success(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadFile"})
    public void fileDownLoad(String path, String name, String downloadName, HttpServletResponse response) {
        if (BeanUtils.isNotEmpty(path) && BeanUtils.isNotEmpty(name)) {
            try {
                path = URLDecoder.decode(path, "UTF-8");
                name = BeanUtils.isNotEmpty(downloadName) ? URLDecoder.decode(downloadName, "UTF-8") : URLDecoder.decode(name, "UTF-8");
                String fileName = "";
                String filePath = "";
                if (path.contains("/")) {
                    filePath = filePath + path.substring(0, path.lastIndexOf("/"));
                    fileName = path.substring(path.lastIndexOf("/") + 1);
                } else {
                    fileName = path;
                }
                response.reset();
                response.setHeader("Set-Cookie", "fileDownload=true; path=/");
                response.setHeader("Content-disposition", "attachment; filename=" + new String(name.getBytes("UTF-8"), "ISO8859-1"));
                response.setHeader("Content-Type", "application/octet-stream");
                ServletOutputStream sos = response.getOutputStream();
                ByteArrayInputStream in = null;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                boolean res = FtpUtil.downLoad(filePath, fileName, out);
                if (res) {
                    in = new ByteArrayInputStream(out.toByteArray());
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = in.read(buffer)) != -1) {
                        sos.write(buffer, 0, len);
                    }
                } else {
                    throw new BusinessException("\u9644\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                out.flush();
                sos.flush();
                sos.close();
                out.close();
                in.close();
            }
            catch (Exception e) {
                log.error("\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25");
                e.printStackTrace();
            }
        } else {
            throw new BusinessException("\u7f3a\u5c11\u5173\u952e\u4fe1\u606f,\u8bf7\u91cd\u8bd5");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/playVideoFile"})
    public void playVideo(@RequestParam(value="path") String path, @RequestParam(value="name") String name, HttpServletRequest request, HttpServletResponse response) {
        if (BeanUtils.isNotEmpty(path) && BeanUtils.isNotEmpty(name)) {
            try {
                RandomAccessFile targetFile;
                File file;
                ServletOutputStream sos;
                ByteArrayInputStream in;
                path = URLDecoder.decode(path, "UTF-8");
                name = URLDecoder.decode(name, "UTF-8");
                String fileName = "";
                String filePath = "";
                if (path.contains("/")) {
                    filePath = filePath + path.substring(0, path.lastIndexOf("/"));
                    fileName = path.substring(path.lastIndexOf("/") + 1);
                } else {
                    fileName = path;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                boolean res = FtpUtil.downLoad(filePath, fileName, out);
                if (res) {
                    in = new ByteArrayInputStream(out.toByteArray());
                    response.reset();
                    String rangeString = request.getHeader("Range");
                    System.out.println("=======rangeString:" + rangeString);
                    sos = response.getOutputStream();
                    String fullPath = "/temp/" + name;
                    file = FileUtil.writeFromStream((InputStream)in, (String)fullPath);
                    System.out.println("==========fullPath:" + fullPath);
                    targetFile = new RandomAccessFile(file, "r");
                    long fileLength = targetFile.length();
                    if (BeanUtils.isNotEmpty(rangeString)) {
                        long range = Long.valueOf(rangeString.substring(rangeString.indexOf("=") + 1, rangeString.indexOf("-")));
                        response.setHeader("Content-Type", "video/mp4");
                        response.setHeader("Content-Length", String.valueOf(fileLength - range));
                        response.setHeader("Content-Range", "bytes " + range + "-" + (fileLength - 1L) + "/" + fileLength);
                        response.setStatus(206);
                        targetFile.seek(range);
                        byte[] cache = new byte[307200];
                        int length = 0;
                        while ((length = targetFile.read(cache)) != -1) {
                            sos.write(cache, 0, length);
                        }
                    }
                } else {
                    throw new BusinessException("\u9644\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                sos.flush();
                sos.close();
                out.flush();
                out.close();
                in.close();
                targetFile.close();
                FileUtil.del((File)file);
            }
            catch (IOException e) {
                log.error("\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25");
                e.printStackTrace();
            }
        } else {
            throw new BusinessException("\u7f3a\u5c11\u5173\u952e\u4fe1\u606f,\u8bf7\u91cd\u8bd5");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/fileToPdf"})
    public void officeFileToPdfFile(String infoId, String path, String name, String sourceType, HttpServletRequest request, HttpServletResponse response) {
        if (BeanUtils.isNotEmpty(sourceType)) {
            if ("01".equals(sourceType)) {
                if (BeanUtils.isNotEmpty(path) && BeanUtils.isNotEmpty(name)) {
                    try {
                        path = URLDecoder.decode(path, "UTF-8");
                        name = URLDecoder.decode(name, "UTF-8");
                        String fileName = "";
                        String filePath = "";
                        if (path.contains("/")) {
                            filePath = filePath + path.substring(0, path.lastIndexOf("/"));
                            fileName = path.substring(path.lastIndexOf("/") + 1);
                        } else {
                            fileName = path;
                        }
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        boolean res = FtpUtil.downLoad(filePath, fileName, out);
                        if (!res) {
                            throw new BusinessException("\u9644\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728");
                        }
                        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                        response.reset();
                        response.setHeader("Content-Type", "application/pdf");
                        String fullPath = "/temp/" + name;
                        File file = FileUtil.writeFromStream((InputStream)in, (String)fullPath);
                        System.out.println("==========fullPath:" + fullPath);
                        FileUtil.del((File)file);
                    }
                    catch (IOException e) {
                        log.error("\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25");
                        e.printStackTrace();
                    }
                } else {
                    throw new BusinessException("\u7f3a\u5c11\u5173\u952e\u4fe1\u606f,\u8bf7\u91cd\u8bd5");
                }
            }
            if ("02".equals(sourceType) && !BeanUtils.isNotEmpty(infoId)) {
                throw new BusinessException("\u7f3a\u5c11\u5173\u952e\u4fe1\u606f,\u8bf7\u91cd\u8bd5");
            }
        } else {
            throw new BusinessException("\u7f3a\u5c11\u5173\u952e\u4fe1\u606f,\u8bf7\u91cd\u8bd5");
        }
    }

    public static void main(String[] args) {
        FileConverterSettings settings = new FileConverterSettings();
        settings.setOffice2PdfEngine(Office2PdfEngineType.MSOFFICE);
        settings.setStorageType(StorageType.UUID);
        try {
            settings.setWorkdir(new File("E:\\other"));
            FileConverterService.init((FileConverterSettings)settings);
        }
        catch (IOException e) {
            log.error("\u6587\u6863\u8f6c\u6362\u5668\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\uff01", (Throwable)e);
            System.exit(-1);
        }
        try {
            FileConverterService.convert((File)new File("E:\\other\\333.docx"), (String)"2133", (OutputType)OutputType.PDF, (boolean)false);
        }
        catch (FileConverterException e) {
            e.printStackTrace();
        }
    }
}

