/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.file.controller;

import cn.hutool.core.date.DateUtil;
import com.google.gson.Gson;
import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.file.entity.FileParamsVo;
import com.kdgcsoft.jt.xzzf.common.file.util.FileUtil;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.FtpUtil;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/fileEditor"})
public class FileEditorServletController {
    private static final Logger log = LogManager.getLogger(FileEditorServletController.class);
    @Resource
    private XzzfProperties xzzfProperties;
    @Resource
    private ShiroCasProperties shiroCasProperties;

    @PostMapping(value={"/uploadFile"})
    public void uploadFile(@RequestParam(value="file") MultipartFile file, HttpServletRequest request, HttpServletResponse response, FileParamsVo entity) throws IOException {
        request.setCharacterEncoding("UTF-8");
        if (BeanUtils.isNotEmpty(this.xzzfProperties.getModelCode())) {
            boolean uploadFile;
            AttachmentVo dbEntity = new AttachmentVo();
            dbEntity.setId(IDUtil.uuid());
            dbEntity.setOldFileName(file.getOriginalFilename());
            dbEntity.setFileSuffix(dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf(".") + 1));
            String savePath = "/event/upload/" + this.xzzfProperties.getModelCode() + "/";
            if (BeanUtils.isNotEmpty(entity)) {
                boolean verify = FileUtil.verifyFileAccept(entity.getAccepts(), dbEntity.getFileSuffix());
                if (!verify) {
                    log.info("\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                }
                if (BeanUtils.isNotEmpty(entity.getAttachType())) {
                    savePath = savePath + entity.getAttachType() + "/";
                }
                if (entity.isAttachByDate()) {
                    savePath = savePath + DateUtil.format((Date)new Date(), (String)"yyyy") + "/" + DateUtil.format((Date)new Date(), (String)"MM") + "/" + DateUtil.format((Date)new Date(), (String)"dd") + "/";
                }
            }
            if (dbEntity.getOldFileName().contains(".")) {
                if (entity.isUseOldName()) {
                    dbEntity.setNewFileName(dbEntity.getOldFileName());
                    dbEntity.setFilePath(savePath + dbEntity.getOldFileName());
                } else {
                    String newFileName = dbEntity.getId() + dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf("."));
                    dbEntity.setNewFileName(newFileName);
                    dbEntity.setFilePath(savePath + newFileName);
                }
            }
            if (uploadFile = FtpUtil.upload(savePath, dbEntity.getNewFileName(), file.getInputStream())) {
                HashMap<String, String> map = new HashMap<String, String>();
                System.out.println("\u9644\u4ef6\u7684\u76f8\u5173\u4fe1\u606f:" + dbEntity.toString());
                map.put("link", this.shiroCasProperties.getService() + "file/downloadFile?path=" + dbEntity.getFilePath() + "&name=" + dbEntity.getNewFileName());
                Gson gson = new Gson();
                response.getWriter().write(gson.toJson(map));
            } else {
                log.info("\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
        } else {
            log.info("\u5b50\u7cfb\u7edf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

