/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.excel.jxls;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.XlsTransformerExt;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.BusinessException;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.AbstractView;

@Component
public class JxlsExcelView
extends AbstractView {
    private static final Logger log = LoggerFactory.getLogger(JxlsExcelView.class);
    private static XzzfProperties xzzfProperties;
    public static final String OPERATE_TYPE = "type";
    public static final String EXCEL_EXPORT_FILE_NAME = "fileName";
    public static final String EXCEL_TEMPLATE_FILE_NAME = "tempFileName";
    public static final String EXCEL_DATA_LIST = "dataList";
    public static final String BASE_PATH = "template";
    public static final String COMMON_PATH = "excel";
    public static final String OPERATE_TYPE_EXPORTS = "exports";
    public static final String OPERATE_TYPE_IMPORTS = "imports";
    private static final String CONTENT_TYPE = "application/vnd.ms-excel;charset=utf-8";
    public static final String EXCEL_DEF_SUFFIX_2007 = "xlsx";
    public static final String EXCEL_DEF_SUFFIX_2003 = "xls";
    public static final String BROWSER_TYPE_IE = "ie";
    public static final String BROWSER_TYPE_FIREFOX = "firefox";
    public static final String BROWSER_TYPE_GOOGLE = "google";
    private XlsTransformerExt transformer = new XlsTransformerExt();

    public JxlsExcelView() {
        this.setContentType(CONTENT_TYPE);
    }

    @Autowired
    public void setXzzfProperties(XzzfProperties xzzfProperties) {
        JxlsExcelView.xzzfProperties = xzzfProperties;
    }

    protected boolean generatesDownloadContent() {
        return true;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DateTime startTime = DateUtil.date();
        boolean isExport = OPERATE_TYPE_EXPORTS.equals((String)model.get(OPERATE_TYPE));
        String operateTypeText = isExport ? "\u5bfc\u51fa" : "\u5bfc\u5165";
        log.info("======================>\u5f00\u59cb" + operateTypeText + "\u65f6\u95f4:" + startTime);
        String fileName = (String)model.get(EXCEL_EXPORT_FILE_NAME);
        String templateName = (String)model.get(EXCEL_TEMPLATE_FILE_NAME);
        String agent = request.getHeader("USER-AGENT").toLowerCase();
        fileName = agent.indexOf(BROWSER_TYPE_FIREFOX) > -1 ? new String(fileName.getBytes("UTF-8"), "ISO-8859-1") : URLEncoder.encode(fileName, "UTF-8");
        response.setHeader("content-disposition", "attachment; filename=" + fileName);
        response.setContentType(this.getContentType());
        String tempRealPath = JxlsExcelView.getTempFileRealPath(isExport, templateName);
        log.info("======================>" + operateTypeText + "\u6a21\u677f\u6587\u4ef6\u8def\u5f84:" + tempRealPath);
        ServletOutputStream out = response.getOutputStream();
        this.transformer.transformXLS(tempRealPath, model, (OutputStream)out, operateTypeText);
        out.flush();
        DateTime endTime = DateUtil.date();
        log.info("======================>\u7ed3\u675f" + operateTypeText + "\u65f6\u95f4:" + endTime);
        log.info("======================>\u5171\u7528" + operateTypeText + "\u65f6\u95f4:" + DateUtil.formatBetween((Date)startTime, (Date)endTime));
    }

    public static void downExcelTemp(String tempFilePath, HttpServletRequest request, HttpServletResponse response) {
        JxlsExcelView.downExcelTemp(null, tempFilePath, request, response);
    }

    public static void downExcelTemp(String fileName, String tempFilePath, HttpServletRequest request, HttpServletResponse response) {
        JxlsExcelView.downExcelTemp(fileName, null, tempFilePath, request, response);
    }

    private static void downExcelTemp(String fileName, String suffix, String tempFilePath, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (BeanUtils.isEmpty(suffix)) {
            suffix = EXCEL_DEF_SUFFIX_2007;
        }
        if (BeanUtils.isEmpty(fileName)) {
            fileName = IDUtil.uuid();
        }
        if (BeanUtils.isEmpty(tempFilePath)) {
            throw new BusinessException("\u5bfc\u5165\u6a21\u677f\u8def\u5f84\u4e0d\u53ef\u4e3a\u7a7a");
        }
        map.put(EXCEL_EXPORT_FILE_NAME, fileName + "." + suffix);
        map.put(EXCEL_TEMPLATE_FILE_NAME, tempFilePath);
        map.put(OPERATE_TYPE, OPERATE_TYPE_IMPORTS);
        try {
            JxlsExcelView jxlsExcelView = new JxlsExcelView();
            jxlsExcelView.render(map, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("======================>\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f\u9519\u8bef:" + e.getMessage());
            throw new BusinessException("======================>\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f\u9519\u8bef:" + e.getMessage());
        }
    }

    public static void exportData(String tempFilePath, List<?> dataList, HttpServletRequest request, HttpServletResponse response) {
        JxlsExcelView.exportData(null, tempFilePath, dataList, request, response);
    }

    public static void exportData(String fileName, String tempFilePath, List<?> dataList, HttpServletRequest request, HttpServletResponse response) {
        JxlsExcelView.exportData(fileName, null, tempFilePath, dataList, request, response);
    }

    private static void exportData(String fileName, String suffix, String tempFilePath, List<?> dataList, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (BeanUtils.isEmpty(suffix)) {
            suffix = EXCEL_DEF_SUFFIX_2007;
        }
        if (BeanUtils.isEmpty(fileName)) {
            fileName = IDUtil.uuid();
        }
        if (BeanUtils.isEmpty(tempFilePath)) {
            throw new BusinessException("\u5bfc\u51fa\u6a21\u677f\u8def\u5f84\u4e0d\u53ef\u4e3a\u7a7a");
        }
        map.put(EXCEL_EXPORT_FILE_NAME, fileName + "." + suffix);
        map.put(EXCEL_TEMPLATE_FILE_NAME, tempFilePath);
        map.put(EXCEL_DATA_LIST, dataList);
        map.put(OPERATE_TYPE, OPERATE_TYPE_EXPORTS);
        try {
            JxlsExcelView jxlsExcelView = new JxlsExcelView();
            jxlsExcelView.render(map, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("======================>\u6587\u4ef6\u5bfc\u51fa\u9519\u8bef:" + e.getMessage());
            throw new BusinessException("======================>\u6587\u4ef6\u5bfc\u51fa\u9519\u8bef:" + e.getMessage());
        }
    }

    protected static String getTempFileRealPath(boolean isExport, String tmpFileName) {
        String tempCommonPath = xzzfProperties.isTempFileMode() ? new File(System.getProperty("user.dir")) + File.separator + BASE_PATH + File.separator + COMMON_PATH + File.separator : JxlsExcelView.class.getClassLoader().getResource("").getPath() + BASE_PATH + File.separator + COMMON_PATH + File.separator;
        log.info("======================>\u516c\u5171\u6a21\u677f\u8def\u5f84\u4fe1\u606f:" + tempCommonPath);
        if (isExport) {
            return tempCommonPath + OPERATE_TYPE_EXPORTS + File.separator + tmpFileName;
        }
        return tempCommonPath + OPERATE_TYPE_IMPORTS + File.separator + tmpFileName;
    }
}

