/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.excel.jxls;

import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.BusinessException;
import com.kdgcsoft.jt.xzzf.common.util.PropertyUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelReadUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelReadUtil.class);

    public static boolean compareExcelTitle(ExcelReader reader, String tempExcelName) {
        String[] tempTitleArr = ExcelReadUtil.getTempExcelTitleList(tempExcelName);
        List<String> tempTitleList = Arrays.asList(tempTitleArr);
        List uploadTitleList = reader.readRow(0);
        logger.info("==========\u5bfc\u5165Excel\u7684\u8868\u5934:" + uploadTitleList);
        return uploadTitleList.containsAll(tempTitleList);
    }

    public static String[] getTempExcelTitleList(String tempExcelName) {
        String tempTitle = ExcelReadUtil.getTempExcelTitle(tempExcelName);
        String[] tempTitleArr = StrUtil.split((CharSequence)tempTitle.substring(1, tempTitle.length() - 1).replace(" ", ""), (CharSequence)",");
        return tempTitleArr;
    }

    public static boolean isRepeatTitle(ExcelReader reader) {
        List uploadTitleList = reader.readRow(0);
        return uploadTitleList.stream().distinct().count() < (long)uploadTitleList.size();
    }

    public static List<Object> getRepeatTitle(ExcelReader reader) {
        List uploadTitleList = reader.readRow(0);
        ArrayList<Object> repeats = new ArrayList<Object>();
        if (ExcelReadUtil.isRepeatTitle(reader)) {
            HashMap map = new HashMap();
            for (Object str : uploadTitleList) {
                if (map.get(str) == null) {
                    map.put(str, str);
                    continue;
                }
                repeats.add(str);
            }
        }
        return repeats;
    }

    public static String getTempExcelTitle(String tempExcelName) {
        String string;
        InputStream in = null;
        ExcelReader reader = null;
        try {
            in = PropertyUtil.class.getResourceAsStream("/excel/imports/" + tempExcelName);
            reader = ExcelUtil.getReader((InputStream)in, (int)0);
            List readAll = reader.read(0, 0);
            logger.info("==========\u6a21\u677fExcel\u7684\u8868\u5934:" + readAll.get(0));
            string = ((List)readAll.get(0)).toString();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                logger.error("Excel\u8bfb\u53d6\u5931\u8d25:" + e.getMessage());
                throw new BusinessException("Excel\u8bfb\u53d6\u5931\u8d25:" + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    public static List<Map<String, Object>> gainExcelInfo(MultipartFile file, Class entityClass, String tempFilePath) {
        ExcelReader reader = null;
        try {
            List dataList;
            reader = ExcelUtil.getReader((InputStream)file.getInputStream());
            boolean canImport = ExcelReadUtil.compareExcelTitle(reader, tempFilePath);
            if (!canImport) {
                throw new BusinessException("\u6a21\u677f\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f");
            }
            if (ExcelReadUtil.isRepeatTitle(reader)) {
                List<Object> repeats = ExcelReadUtil.getRepeatTitle(reader);
                throw new BusinessException("\u6a21\u677f\u5b58\u5728\u91cd\u590d\u5217\uff1a" + repeats.toString());
            }
            List list = dataList = reader.readAll();
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Excel\u8bfb\u53d6\u5931\u8d25:" + e.getMessage());
            throw new BusinessException("Excel\u8bfb\u53d6\u5931\u8d25:" + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
    }

    public static List<Object> gainExcelInfoToEntity(MultipartFile file, Class entityClass, String tempFilePath) {
        List<Map<String, Object>> dataList = ExcelReadUtil.gainExcelInfo(file, entityClass, tempFilePath);
        return ExcelReadUtil.gainExcelInfoToEntityInfo(dataList, tempFilePath);
    }

    public static List<Object> gainExcelInfoToEntityInfo(List<Map<String, Object>> dataList, String tempFilePath) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        String[] tempTitleList = ExcelReadUtil.getTempExcelTitleList(tempFilePath);
        if (BeanUtils.isNotEmpty(tempTitleList) && BeanUtils.isNotEmpty(tempTitleList)) {
            for (Map<String, Object> rowDataInfo : dataList) {
                for (String col : tempTitleList) {
                    System.out.println("=========data:" + Objects.toString(rowDataInfo.get(col), null));
                }
            }
        }
        return entityList;
    }
}

