/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.excel.easy;

import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.kdgcsoft.jt.xzzf.common.excel.easy.ExcelListener;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class EasyExcelUtil {
    public static final String EXCEL_DEF_SUFFIX_2007 = "xlsx";
    public static final String EXCEL_DEF_SUFFIX_2003 = "xls";

    public static List<Object> readExcel(MultipartFile file, BaseRowModel rowModel) {
        try {
            return EasyExcelUtil.readExcel(file, rowModel, 1, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Object> readExcel(MultipartFile file, BaseRowModel rowModel, int sheetNo, int headLineNum) throws IOException {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader reader = EasyExcelUtil.getReader(file, excelListener);
        if (reader == null) {
            return null;
        }
        reader.read(new Sheet(sheetNo, headLineNum, rowModel.getClass()));
        return excelListener.getDatas();
    }

    public static List<Object> readExcel(MultipartFile file, BaseRowModel rowModel, String sheetName) throws IOException {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader reader = EasyExcelUtil.getReader(file, excelListener);
        if (reader == null) {
            return null;
        }
        for (Sheet sheet : reader.getSheets()) {
            if (rowModel != null) {
                sheet.setClazz(rowModel.getClass());
            }
            if (!sheet.getSheetName().contains(sheetName)) continue;
            reader.read(sheet);
            break;
        }
        return excelListener.getDatas();
    }

    private static ExcelReader getReader(MultipartFile file, ExcelListener excelListener) throws IOException {
        String fileName = file.getOriginalFilename();
        if (BeanUtils.isNotEmpty(fileName)) {
            if (fileName.toLowerCase().endsWith(".xlsx") || fileName.toLowerCase().endsWith(".xls")) {
                BufferedInputStream is = new BufferedInputStream(file.getInputStream());
                return new ExcelReader((InputStream)is, null, (AnalysisEventListener)excelListener, false);
            }
            return null;
        }
        return null;
    }

    private static void verify(MultipartFile file, String tempFilePath) {
    }
}

