/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.controller;

import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.AppBusinessException;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
public class ExceptionControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionControllerAdvice.class);

    @ExceptionHandler(value={Exception.class})
    public Result error(Exception e) {
        log.error("error", (Throwable)e);
        if (e instanceof BusinessException) {
            BusinessException busException = (BusinessException)e;
            return Result.fail(busException.getMessage());
        }
        if (e instanceof MaxUploadSizeExceededException) {
            return Result.fail("\u9644\u4ef6\u5df2\u8d85\u51fa\u89c4\u5b9a\u5927\u5c0f\uff01");
        }
        if (e instanceof AppBusinessException) {
            return Result.fail(e.getMessage());
        }
        return Result.fail("\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    @ExceptionHandler(value={BindException.class})
    public Result bindError(BindException e, BindingResult result) {
        log.error("error", (Throwable)e);
        List fieldErrors = result.getFieldErrors();
        if (BeanUtils.isNotEmpty(fieldErrors)) {
            StringBuilder sb = new StringBuilder();
            for (FieldError error : fieldErrors) {
                sb.append(error.getField()).append(":").append(error.getDefaultMessage());
            }
            return Result.fail(sb.toString());
        }
        return Result.fail();
    }
}

