/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.component.DTreeResponseVo;
import com.kdgcsoft.jt.xzzf.common.component.ReportDtreeVo;
import com.kdgcsoft.jt.xzzf.common.component.StatusVo;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import com.kdgcsoft.jt.xzzf.common.util.ShiroUtil;
import com.kdgcsoft.jt.xzzf.common.util.SysUtils;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDept;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysDeptService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysDicService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysMenuService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysOrgService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysRoleService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysSubSystemService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysUserRoleService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysUserService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysXzqhService;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.common.service.CommonService;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.common.service.XzspCommonService;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.rygl.entity.ZfRyDataVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.rygl.entity.ZfRyXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.rygl.service.ZfRyXxService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class CommonController {
    private static final Logger log = LogManager.getLogger(CommonController.class);
    @Reference(check=false, lazy=true)
    private SysDicService sysDicService;
    @Reference(check=false, lazy=true)
    private SysOrgService sysOrgService;
    @Reference(check=false, lazy=true)
    private SysDeptService sysDeptService;
    @Reference(check=false, lazy=true)
    private SysMenuService sysMenuService;
    @Reference(check=false, lazy=true)
    private CommonService commonService;
    @Reference(check=false, lazy=true)
    private XzspCommonService xzspCommonService;
    @Reference(check=false, lazy=true)
    private SysXzqhService sysXzqhService;
    @Reference(check=false, lazy=true)
    private ZfRyXxService zfRyXxService;
    @Reference(check=false, lazy=true)
    private SysUserService sysUserService;
    @Reference(check=false, lazy=true)
    private SysSubSystemService sysSubSystemService;
    @Reference(check=false, lazy=true)
    private SysRoleService sysRoleService;
    @Reference(check=false, lazy=true)
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private XzzfProperties xzzfProperties;
    @Autowired
    private RedisUtil redisUtil;

    @RequestMapping(value={"/getUserInfo"})
    public Result getUserInfo() {
        SysUser userInfo = this.sysUserRoleService.getUserSpecRoleInfo(this.xzzfProperties.getSubSysKey(), SysUtils.getCurUser());
        return Result.success(userInfo);
    }

    @RequestMapping(value={"/getDeptByOrgId"})
    public Result getDeptByOrgId(@RequestParam(value="orgId") String orgId) {
        List<SysDept> list = this.sysDeptService.getEntityDataListByOrgId(orgId);
        return Result.success(list);
    }

    @RequestMapping(value={"/getListByCode"})
    public Result combobox(String dictCode) {
        List<ComboboxVo> list = this.sysDicService.queryEntityCombobox(dictCode);
        return Result.success(list);
    }

    @RequestMapping(value={"/dictCombobox"})
    public Result dictCombobox(String dictCode) {
        List<ComboboxVo> list = this.sysDicService.queryEntityCombobox(dictCode);
        return Result.success(list);
    }

    @RequestMapping(value={"/getDictText"})
    public Result getTextByCodeAndValue(String dictCode, String dictValue) {
        String dictText = this.sysDicService.getDictText(dictCode, dictValue);
        return Result.success(dictText, "\u67e5\u8be2\u6210\u529f");
    }

    @RequestMapping(value={"/menuTree"})
    public Result menuTree(SysMenu entity) {
        return Result.success(this.sysMenuService.queryMenuTreeDataList(entity));
    }

    @RequestMapping(value={"/orgTree"})
    public Result orgTree(@RequestParam(value="orgId", required=false) String orgId, String filter) {
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryOrgTreeData(orgId, filter, SysUtils.getCurUserOrgId());
        return Result.success(treeDataVos);
    }

    @RequestMapping(value={"/allOrgTree"})
    public Result allOrgTree(@RequestParam(value="orgId", required=false) String orgId, String filter) {
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryOrgTreeData(orgId, filter, "0");
        return Result.success(treeDataVos);
    }

    @RequestMapping(value={"/orgParTree"})
    public Result orgParTree(@RequestParam(value="orgId", required=false) String orgId, String filter) {
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryOrgParTreeData(orgId, filter, SysUtils.getCurUserOrgId());
        return Result.success(treeDataVos);
    }

    @RequestMapping(value={"/crossUnitOrgTree"})
    public Result crossUnitOrgTree(@RequestParam(value="orgId", required=false) String orgId, String filter) {
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryCrossUnitOrgTreeData(orgId, filter, SysUtils.getCurUserOrgId());
        return Result.success(treeDataVos);
    }

    @RequestMapping(value={"/sameLevelOrgTree"})
    public Result sameLevelTree(String orgId, String filter) {
        List<TreeDataVo> treeList = this.sysOrgService.querySameLevelOrgTree(orgId, filter, SysUtils.getCurUserOrgId());
        return Result.success(treeList);
    }

    @RequestMapping(value={"/orgPage"})
    public Result pageData(@RequestParam(defaultValue="1") long current, @RequestParam(defaultValue="10") long size, SysOrg entity) {
        Page<SysOrg> page = this.sysOrgService.page((Page<SysOrg>)new Page(current, size), entity, SysUtils.getCurUserOrgId());
        return Result.success(page);
    }

    @RequestMapping(value={"/orgList"})
    public Result orgList(SysOrg entity) {
        return Result.success(this.sysOrgService.dataList(entity, SysUtils.getCurUserOrgId()));
    }

    @RequestMapping(value={"/orgCombobox"})
    public Result orgCombobox(String filter, String containFilters, String xzqhId) {
        return Result.success(this.sysOrgService.queryEntityInfoComboboxByContainFiltersAndXzqhId(filter, containFilters, xzqhId));
    }

    @RequestMapping(value={"/queryUserMenu"})
    public Result queryUserMenu() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (BeanUtils.isNotEmpty((Object)ShiroUtil.getLoginUser())) {
            map.put("menuInfo", ShiroUtil.getLoginUser().getMenuInfo());
        } else {
            map.put("menuInfo", this.sysMenuService.queryAuthMenuByUserIdAndSubSysId(SysUtils.getCurUser().getUserId(), this.xzzfProperties.getSubSysKey()));
        }
        map.put("sysInfo", this.sysSubSystemService.getEntityInfoById(this.xzzfProperties.getSubSysKey()));
        SysUser curUser = this.sysUserRoleService.getUserSpecRoleInfo(this.xzzfProperties.getSubSysKey(), SysUtils.getCurUser());
        map.put("userInfo", curUser);
        return Result.success(map);
    }

    @RequestMapping(value={"/modifyPwd"})
    public Result modifyPwd(SysUser entity) {
        this.sysUserService.modifyPwd(entity, SysUtils.getCurUser(), SysUtils.curUserIsSuperAdmin());
        this.redisUtil.set("user_" + entity.getUserId(), JSON.toJSONString((Object)this.sysUserService.getEntityInfoById(entity.getUserId())));
        return Result.msg("\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/xzqhTree"})
    public Result getXzQhInfo(@RequestParam(value="xzqhid", required=false) String xzqhId, @RequestParam(value="xzqhdj", required=false) String xzqhdj, @RequestParam(value="fanwei", required=false) String fanwei, @RequestParam(value="filter", required=false) String filter) {
        List<TreeDataVo> list = this.sysXzqhService.getXzQhTreeInfo(xzqhId, xzqhdj, fanwei, filter);
        return Result.success(list);
    }

    @RequestMapping(value={"/xzqhScopeTree"})
    public Result xzqhScopeTree(@RequestParam(value="xzqhbm", required=false) String xzqhbm, String xzqhLevels, String filter) {
        List<TreeDataVo> treeDataVos = this.sysXzqhService.queryScopeRecXzqhTreeData(xzqhbm, xzqhLevels, filter);
        return Result.success(treeDataVos);
    }

    @RequestMapping(value={"/subSysCombobox"})
    public Result subSysCombobox(String filter) {
        return Result.success(this.sysSubSystemService.queryEntityInfoCombobox(filter, this.xzzfProperties.getSubSysKey()));
    }

    @RequestMapping(value={"/subSysCodeCombobox"})
    public Result subSysCodeCombobox(String filter) {
        return Result.success(this.sysSubSystemService.queryEntityInfoCodeCombobox(filter, this.xzzfProperties.getSubSysKey()));
    }

    @RequestMapping(value={"/sysUserCombobox"})
    public Result sysUserCombobox(String filter) {
        return Result.success(this.sysUserService.queryEntityInfoCombobox(filter, SysUtils.getCurUserOrgId()));
    }

    @RequestMapping(value={"/queryZfryInfoByZfzh"})
    public Result queryZfRyInfoByZfZh(@RequestParam(value="zfzh") String zfzh) {
        ZfRyXxVO zfRyXxVO = this.zfRyXxService.queryZfRyInfoByZfZh(zfzh);
        return Result.success(zfRyXxVO);
    }

    @RequestMapping(value={"/queryUserByOrgId"})
    public Result queryUserByOrgId(@RequestParam(defaultValue="1") long current, @RequestParam(defaultValue="10") long size, SysUser entity, boolean showOrgChildUser) {
        return Result.success(this.sysUserService.pageDataByOrgId((Page<SysUser>)new Page(current, size), entity, SysUtils.getCurUserOrgId(), showOrgChildUser));
    }

    @RequestMapping(value={"/queryZfRyInfoList"})
    public Result queryZfRyInfoList(@RequestParam(defaultValue="1") long current, @RequestParam(defaultValue="10") long size, @RequestParam(value="parameters", required=false) String parameters, @RequestParam(value="orgId", required=false) String orgId) {
        if (StrUtil.isEmpty((CharSequence)orgId)) {
            Result.fail(ResultCode.FAIL, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ZfRyDataVO zfRyDataVO = new ZfRyDataVO();
        zfRyDataVO.setParameters(parameters);
        zfRyDataVO.setOrgId(orgId);
        Page<ZfRyDataVO> list = this.zfRyXxService.queryZfRyInfoList(current, size, zfRyDataVO);
        if (ObjectUtil.isNotEmpty(list)) {
            return Result.success(list);
        }
        return Result.msg("\u6682\u65e0\u6570\u636e");
    }

    @RequestMapping(value={"/queryZfryByZfRyXxId"})
    public Result queryZfryByZfRyXxId(@RequestParam(value="id", required=false) String zfryxxId) {
        ZfRyDataVO zfRyDataVO;
        if (StrUtil.isEmpty((CharSequence)zfryxxId)) {
            Result.fail(ResultCode.FAIL, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)(zfRyDataVO = this.zfRyXxService.queryZfryByZfRyXxId(zfryxxId)))) {
            return Result.msg("\u6682\u65e0\u6570\u636e");
        }
        return Result.success(zfRyDataVO);
    }

    @RequestMapping(value={"/queryZfRyInfoByOrgId"})
    public Result queryZfRyInfoByOrgId(@RequestParam(value="orgId", required=false) String orgId) {
        if (StrUtil.isEmpty((CharSequence)orgId)) {
            Result.fail(ResultCode.FAIL, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ZfRyXxVO> zfRyXxVOS = this.zfRyXxService.queryZfRyInfoByOrgId(orgId);
        return Result.success(zfRyXxVOS);
    }

    @RequestMapping(value={"/xzqhDtree"})
    public DTreeResponseVo xzqhDtree(@RequestParam(value="xzqhid", required=false) String xzqhId, @RequestParam(value="xzqhdj", required=false) String xzqhdj, @RequestParam(value="fanwei", required=false) String fanwei, @RequestParam(value="filter", required=false) String filter) {
        List<TreeDataVo> list = this.sysXzqhService.getXzQhTreeInfo(xzqhId, xzqhdj, fanwei, filter);
        ArrayList<ReportDtreeVo> list1 = new ArrayList<ReportDtreeVo>();
        for (TreeDataVo vo : list) {
            ReportDtreeVo reportDtreeVo = new ReportDtreeVo();
            reportDtreeVo.setId(vo.getNodeId());
            reportDtreeVo.setTitle(vo.getNodeName());
            reportDtreeVo.setParentId(vo.getNodePid());
            list1.add(reportDtreeVo);
        }
        DTreeResponseVo dTreeResponse = new DTreeResponseVo();
        StatusVo status = new StatusVo();
        dTreeResponse.setStatus(status);
        dTreeResponse.setData(list1);
        dTreeResponse.setMsg("\u64cd\u4f5c\u6210\u529f");
        return dTreeResponse;
    }

    @RequestMapping(value={"/getlOrgTree"})
    public DTreeResponseVo getOrgTree(String orgId, String filter) {
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryOrgTreeData(orgId, filter, "0");
        ArrayList<ReportDtreeVo> list1 = new ArrayList<ReportDtreeVo>();
        for (TreeDataVo vo : treeDataVos) {
            ReportDtreeVo reportDtreeVo = new ReportDtreeVo();
            reportDtreeVo.setId(vo.getNodeId());
            reportDtreeVo.setTitle(vo.getNodeName());
            reportDtreeVo.setParentId(vo.getNodePid());
            list1.add(reportDtreeVo);
        }
        DTreeResponseVo dTreeResponse = new DTreeResponseVo();
        StatusVo status = new StatusVo();
        dTreeResponse.setStatus(status);
        dTreeResponse.setData(list1);
        dTreeResponse.setMsg("\u64cd\u4f5c\u6210\u529f");
        return dTreeResponse;
    }
}

