/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.config.shiro;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.jt.xzzf.common.entity.OnLineUser;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.online.OnLineUserService;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.SpringContextHolder;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.UserFilter;

public class XzzfUniqueUserFilter
extends UserFilter {
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginRequest(request, response)) {
            return true;
        }
        Subject subject = this.getSubject(request, response);
        return subject.getPrincipal() != null && this.checkSessionTgt((HttpServletRequest)request, (HttpServletResponse)response);
    }

    private boolean checkSessionTgt(HttpServletRequest request, HttpServletResponse response) {
        OnLineUserService onLineUserService = SpringContextHolder.getBean(OnLineUserService.class);
        return onLineUserService.checkSessionTgt(request.getSession().getId());
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (this.getSubject(request, response).getPrincipal() != null) {
            OnLineUserService onLineUserService = SpringContextHolder.getBean(OnLineUserService.class);
            OnLineUser onLineUser = onLineUserService.getCurrentOnlineUser();
            Result fail = Result.fail(ResultCode.OFFLINE, "\u60a8\u7684\u8d26\u53f7\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u767b\u9646\uff0c\u60a8\u5df2\u6389\u7ebf\uff01");
            if (StrUtil.equals((CharSequence)"1", (CharSequence)onLineUser.getStatus())) {
                fail.setMessage("\u60a8\u5df2\u88ab\u5f3a\u5236\u4e0b\u7ebf\uff01");
            }
            response.setCharacterEncoding("UTF-8");
            httpServletResponse.setCharacterEncoding("utf-8");
            httpServletResponse.setContentType("application/json; charset=utf-8");
            try (PrintWriter writer = httpServletResponse.getWriter();){
                fail.setLoginSuccess("2");
                writer.write(JSON.toJSONString((Object)fail));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            httpServletResponse.setStatus(300);
            return false;
        }
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter writer = response.getWriter();
        Result fail = Result.fail(ResultCode.FORBID, "\u56e0\u957f\u65f6\u95f4\u672a\u64cd\u4f5c\uff0c\u60a8\u5df2\u5f3a\u5236\u4e0b\u7ebf\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u7cfb\u7edf\uff01");
        fail.setLoginSuccess("0");
        writer.write(JSON.toJSONString((Object)fail));
        return false;
    }
}

