/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.config.shiro;

import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.config.annotation.Reference;
import com.kdgcsoft.jt.xzzf.common.component.AuthMenuVo;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.entity.LoginUser;
import com.kdgcsoft.jt.xzzf.common.log.AsyncLog;
import com.kdgcsoft.jt.xzzf.common.log.factory.LogRunableFactory;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.IPUtil;
import com.kdgcsoft.jt.xzzf.common.util.UserAgentUtil;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysRole;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.LoginUserService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysMenuService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysRoleService;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysUserService;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.exception.LoginException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class CasShiroRealm
extends CasRealm {
    @Resource
    private ShiroCasProperties shiroCasProperties;
    @Resource
    private XzzfProperties xzzfProperties;
    @Reference(check=false, lazy=true)
    private LoginUserService loginUserService;
    @Reference(check=false, lazy=true)
    private SysRoleService sysRoleService;
    @Reference(check=false, lazy=true)
    private SysMenuService sysMenuService;
    @Reference(check=false, lazy=true)
    private SysUserService sysUserService;
    private static final Logger LOG = LoggerFactory.getLogger(CasShiroRealm.class);

    @PostConstruct
    public void initProperties() {
        LOG.info("\u914d\u7f6e\u57fa\u672c\u5c5e\u6027");
        this.setDefaultRoles("ROLE_USER");
        this.setCasServerUrlPrefix(StrUtil.isNotEmpty((CharSequence)this.shiroCasProperties.getTicketValidateUrl()) ? this.shiroCasProperties.getTicketValidateUrl() : this.shiroCasProperties.getCasServerUrl());
        this.setCasService(this.shiroCasProperties.getService() + "toIndex");
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        LoginUser loginUser = (LoginUser)((Object)principals.getPrimaryPrincipal());
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        List<SysRole> roles = this.sysRoleService.queryUserRoleRelByUserId(loginUser.getLoginUserId());
        authorizationInfo.setRoles(roles.stream().map(SysRole::getRoleCode).collect(Collectors.toSet()));
        List<AuthMenuVo> authMenu = this.sysMenuService.queryAuthMenuByUserIdAndSubSysId(loginUser.getLoginUserId(), this.xzzfProperties.getSubSysKey());
        authorizationInfo.setStringPermissions(authMenu.stream().map(AuthMenuVo::getMenuCode).collect(Collectors.toSet()));
        return authorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        LOG.info("\u8fdb\u5165doGetAuthenticationInfo");
        try {
            LoginUser loginUser;
            boolean isRemembered;
            Assertion casAssertion;
            CasToken casToken = (CasToken)token;
            if (token == null) {
                return null;
            }
            String ticket = (String)casToken.getCredentials();
            if (!StringUtils.hasText((String)ticket)) {
                return null;
            }
            TicketValidator ticketValidator = this.ensureTicketValidator();
            try {
                casAssertion = ticketValidator.validate(ticket, this.getCasService());
            }
            catch (TicketValidationException e) {
                throw new LoginException("\u7528\u6237\u540d\u5bc6\u7801\u51fa\u9519", (Exception)((Object)e));
            }
            LOG.info("\u8fdc\u7a0b\u9a8c\u8bc1\u901a\u8fc7");
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String userName = casPrincipal.getName();
            Map attributes = casPrincipal.getAttributes();
            casToken.setUserId(userName);
            String rememberMeAttributeName = this.getRememberMeAttributeName();
            String rememberMeStringValue = (String)attributes.get(rememberMeAttributeName);
            boolean bl = isRemembered = rememberMeStringValue != null && Boolean.parseBoolean(rememberMeStringValue);
            if (isRemembered) {
                casToken.setRememberMe(true);
            }
            try {
                loginUser = this.loginUserService.loadLoginUserByUserName(userName);
                SysUser sysUser = this.sysUserService.findUserInfoByName(userName);
                loginUser.setSysUser(sysUser);
                loginUser.setUserId(1L);
                loginUser.setUserName(sysUser.getUserName());
            }
            catch (NullPointerException e) {
                throw new LoginException("\u7528\u6237\u4e0d\u5b58\u5728", (Exception)e);
            }
            List<SysRole> roles = this.sysRoleService.queryUserOwnRoleListByUserId(loginUser.getLoginUserId(), "1".equals(loginUser.getSysUser().getSuperAdmin()));
            loginUser.setRoles(roles.stream().map(SysRole::getRoleId).collect(Collectors.toList()));
            List<AuthMenuVo> authMenu = this.sysMenuService.queryAuthMenuByUserIdAndSubSysId(loginUser.getLoginUserId(), this.xzzfProperties.getSubSysKey());
            loginUser.setMenuInfo(authMenu);
            List<String> collect = authMenu.stream().map(AuthMenuVo::getMenuCode).collect(Collectors.toList());
            authMenu.forEach(x -> {
                if (BeanUtils.isNotEmpty(x.getToolButtons())) {
                    x.getToolButtons().forEach(y -> collect.add(x.getMenuCode() + "." + y));
                }
                if (BeanUtils.isNotEmpty(x.getColButtons())) {
                    x.getColButtons().forEach(y -> collect.add(x.getMenuCode() + "." + y));
                }
            });
            loginUser.setPermissions(collect);
            List principals = CollectionUtils.asList((Object[])new Object[]{loginUser, attributes});
            SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Collection)principals, this.getName());
            if (this.xzzfProperties.isLogEnable()) {
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                AsyncLog.getInstance().executeLog(LogRunableFactory.loginLog(loginUser.getLoginUserId(), userName, IPUtil.getIpAddress(request), "browser\uff1a" + UserAgentUtil.getBrower().getName() + " version\uff1a" + UserAgentUtil.getUserAgent().getVersion(), this.xzzfProperties.getSubSysKey()));
            }
            return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)ticket);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }
}

