/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.config.interceptor;

import com.alibaba.dubbo.config.annotation.Reference;
import com.kdgcsoft.jt.xzzf.common.component.AuthMenuVo;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.util.MenuTreeHelper;
import com.kdgcsoft.jt.xzzf.common.util.SysUtils;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysMenuService;
import com.kdgcsoft.scrdc.frame.webframe.core.model.UiTreeNode;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class IndexInterceptor
implements HandlerInterceptor {
    @Reference(check=false, lazy=true)
    private SysMenuService sysMenuService;
    @Autowired
    private XzzfProperties xzzfProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String path = request.getServletPath();
        return !this.xzzfProperties.isFrontEnable() || !"/".equals(path);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        String servletPath = request.getServletPath();
        if (!this.xzzfProperties.isFrontEnable() && "/".equals(servletPath)) {
            List<AuthMenuVo> sysMenus = this.sysMenuService.queryAuthMenuByUserIdAndSubSysId(SysUtils.getCurUser().getUserId(), this.xzzfProperties.getSubSysKey());
            List<UiTreeNode> uiTreeNodes = MenuTreeHelper.buildFullMenuTree(sysMenus);
            modelAndView.addObject("userMenus", uiTreeNodes);
        }
    }
}

