/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.common.cache;

import cn.hutool.core.util.ClassUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.jt.xzzf.common.cache.CacheService;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDic;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CacheUtil {
    private static final Logger log = LoggerFactory.getLogger(CacheUtil.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    ConfigurableApplicationContext configurableContex;

    public String getDicText(String dicCode, String dicValue) {
        SysDic dbEntity = this.getDic(dicCode, dicValue);
        if (BeanUtils.isEmpty(dbEntity)) {
            return "";
        }
        return dbEntity.getDicText();
    }

    public String getDicValue(String dicCode, String dicText) {
        SysDic dbEntity = this.getDicByCodeAndText(dicCode, dicText);
        if (BeanUtils.isEmpty(dbEntity)) {
            return "";
        }
        return dbEntity.getDicValue();
    }

    public SysDic getDic(String dicCode, String dicValue) {
        if (BeanUtils.isEmpty(dicValue) || BeanUtils.isEmpty(dicCode)) {
            return null;
        }
        return (SysDic)JSON.parseObject((String)this.redisUtil.get("dic_" + dicCode + "_" + dicValue), SysDic.class);
    }

    public SysDic getDicByCodeAndText(String dicCode, String dicText) {
        if (BeanUtils.isEmpty(dicText) || BeanUtils.isEmpty(dicCode)) {
            return null;
        }
        return (SysDic)JSON.parseObject((String)this.redisUtil.get("dic_" + dicCode + "_" + dicText), SysDic.class);
    }

    public List<SysDic> getDicList(String dicCode) {
        return JSON.parseArray((String)this.redisUtil.get("type_dic_" + dicCode), SysDic.class);
    }

    public List<ComboboxVo> getDicComboxList(String dicCode) {
        return JSON.parseArray((String)this.redisUtil.get("type_combox_dic_" + dicCode), ComboboxVo.class);
    }

    public SysOrg getOrg(String orgId) {
        return (SysOrg)JSON.parseObject((String)this.redisUtil.get("org_" + orgId), SysOrg.class);
    }

    public SysUser getUser(String userId) {
        return (SysUser)JSON.parseObject((String)this.redisUtil.get("user_" + userId), SysUser.class);
    }

    public String getAppClientId(String userId) {
        return this.redisUtil.get("clientid_" + userId);
    }

    @PostConstruct
    public void initCache() {
        for (Class clazz : ClassUtil.scanPackageBySuper((String)"com", CacheService.class)) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
            try {
                CacheService cacheService = (CacheService)this.configurableContex.getBean(clazz);
                if (cacheService.isInit()) continue;
                cacheService.loadDatas();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u7f13\u5b58\u521d\u59cb\u5316\u5931\u8d25\uff01", e);
            }
        }
    }
}

