package com.kdgcsoft.dtp.plugin.reader.databasereader.service.impl;

import com.kdgcsoft.dtp.plugin.common.databasecommon.exception.JdbcQueryException;
import com.kdgcsoft.dtp.plugin.common.databasecommon.util.DBUtil;
import com.kdgcsoft.dtp.plugin.reader.databasereader.service.ResultSetHandler;

import java.sql.*;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StringArrayResultSetHandler implements ResultSetHandler<String[]> {


    private final Map<Integer,Integer> typeMapping = new HashMap<>();

    private int columnCount = 0;
    /**
     * 处理结果集<br>
     * 结果集处理后不需要关闭
     *
     * @param rs 结果集
     * @return 处理后生成的对象
     * @throws SQLException SQL异常
     */
    @Override
    public String[] handle(ResultSet rs) throws JdbcQueryException {
        String[] str;
        try {
            str = new String[getColumnCount(rs)];
            for (int i = 0; i < getColumnCount(rs); i++) {
                str[i] = DBUtil.valueToString(rs,  i+1,getColumnType(rs, i+1));
            }
        } catch (SQLException e) {
            throw new JdbcQueryException(e,0);
        }
        return  str;
    }


    /**
     * 获取查询列表的数量
     * @param rs
     * @return
     * @throws SQLException
     */
    private int getColumnCount(ResultSet rs) throws SQLException {
        if (columnCount != 0 ) {
            return columnCount;
        }
        columnCount = rs.getMetaData().getColumnCount();
        return columnCount;
    }

    /**
     * 获取字段类型
     * @param res   查询结果集
     * @param i     数据列索引
     * @return      数据列类型
     * @throws SQLException 查询异常
     */
    private Integer getColumnType(ResultSet res,int i) throws SQLException {
        Integer columnType = typeMapping.get(i);
        if (Objects.isNull(columnType)) {
             columnType = res.getMetaData().getColumnType(i);
            typeMapping.put(i, columnType);
        }
        return columnType;
    }

}
