package com.kdgcsoft.dtp.plugin.reader.databasereader.service;

import com.kdgcsoft.dtp.plugin.reader.databasereader.entity.QueryEntityType;

import java.util.List;

public interface AbstractBlockWriteStreamWriter extends StreamWriter<String[]> {

    void writeHead(String[] head);

    void writeBody(String[] body);


    /**
     * 添加元素
     *
     * @param a    元素对象
     * @param type 添加元素类型
     */
    @Override
    default void addData(String[] a, QueryEntityType type) {
            if (QueryEntityType.HEAD.equals(type)) {
                writeHead(a);
            }
    }

    /**
     * 添加元素（集合类型）
     *
     * @param a 元素对象的集合
     */
    @Override
   default void addList(List<String[]> a) {
        for (String[] s : a) {
            writeBody(s);
        }
    };
}
