/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.service.impl;

import cn.hutool.json.JSONUtil;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.IUser;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2Dept;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2Role;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2User;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.service.ISysUserService;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.domain.SysUser;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.mapper.SysUserMapper;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.service.ISysPermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysUserServiceImpl<U extends IUser>
implements ISysUserService<SysUser> {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    private final SysUserMapper userMapper;
    private final ISysPermissionService sysPermissionService;

    public SysUserServiceImpl(SysUserMapper userMapper, ISysPermissionService sysPermissionService) {
        this.userMapper = userMapper;
        this.sysPermissionService = sysPermissionService;
    }

    public SysUser selectUserByLoginName(String userName) {
        return this.userMapper.selectUserByLoginName(userName);
    }

    public SysUser selectUserByPhoneNumber(String phoneNumber) {
        return this.userMapper.selectUserByPhoneNumber(phoneNumber);
    }

    public Oauth2User createLoginUser(SysUser user, String clientId) {
        return new Oauth2User().setDept((Oauth2Dept)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)user.getDept()), Oauth2Dept.class)).setLoginName(user.getLoginName()).setRoles(JSONUtil.toList((String)JSONUtil.toJsonStr(user.getRoles()), Oauth2Role.class)).setLoginIp(user.getLoginIp()).setUserId(user.getUserId()).setDeptId(user.getDeptId()).setUsername(user.getUserName()).setPassword(user.getPassword()).setEmail(user.getEmail()).setPhonenumber(user.getPhonenumber()).setSex(user.getSex()).setStatus(user.getStatus()).setPwdUpdateDate(user.getPwdUpdateDate()).setLoginDate(user.getLoginDate()).setDelFlag(user.getDelFlag()).setSalt(user.getSalt()).setAvatar(user.getAvatar()).setMenuPermissions(this.sysPermissionService.getMenuPermission(user)).setRolePermissions(this.sysPermissionService.getRolePermission(user));
    }
}

