/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.service.impl;

import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.domain.SysRole;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.domain.SysUser;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.mapper.SysRoleMapper;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.service.ISysPermissionService;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.service.ISysRoleService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionService
implements ISysPermissionService {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private SysRoleMapper roleMapper;

    @Override
    public Set<String> getMenuPermission(SysUser user) {
        HashSet<String> permsSet = new HashSet<String>();
        if (user.isAdmin()) {
            permsSet.add("*:*:*");
        } else {
            List<SysRole> perms = this.roleMapper.selectRolesByUserId(Long.parseLong(user.getUserId()));
            for (SysRole perm : perms) {
                if (!Objects.nonNull(perm)) continue;
                permsSet.addAll(Arrays.asList(perm.getRoleKey().trim().split(",")));
            }
        }
        return permsSet;
    }

    @Override
    public Set<String> getRolePermission(SysUser user) {
        HashSet<String> perms = new HashSet<String>();
        if (user.isAdmin()) {
            perms.add("*:*:*");
        } else {
            perms.addAll(this.roleService.selectRolePermissionByUserId(Long.parseLong(user.getUserId())));
        }
        return perms;
    }
}

