/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.config;

import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.IUser;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.service.ISysUserService;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.service.PasswordEncoderProxy;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.mapper.SysUserMapper;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.service.ISysPermissionService;
import com.kdgcsoft.citybg.datacenter.authentication.user.ruoyi.service.impl.SysUserServiceImpl;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BeanConfig {
    @Bean
    @ConditionalOnMissingBean(value={PasswordEncoderProxy.class})
    PasswordEncoderProxy ruoYiPasswordEncoder() {
        return new PasswordEncoderProxy(){

            public String encode(CharSequence rawPassword) {
                return new Md5Hash((Object)rawPassword).toHex();
            }

            public boolean matches(CharSequence rawPassword, String encodedPassword) {
                return new Md5Hash((Object)rawPassword).toHex().equalsIgnoreCase(encodedPassword);
            }
        };
    }

    @Bean
    ISysUserService<IUser> sysUserService(@Autowired SysUserMapper sysUserMapper, @Autowired ISysPermissionService service) {
        return new SysUserServiceImpl(sysUserMapper, service);
    }
}

