/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.service.impl;

import cn.hutool.json.JSONUtil;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.IUser;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2Dept;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2Role;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2User;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.service.ISysUserService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.entity.SysUser;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.mapper.SysUserMapper;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.service.ISysPermissionService;

public class SysUserServiceImpl<U extends IUser>
implements ISysUserService<SysUser> {
    private final ISysPermissionService<SysUser> sysPermissionService;
    private final SysUserMapper sysUserMapper;

    public SysUserServiceImpl(ISysPermissionService<SysUser> sysPermissionService, SysUserMapper sysUserMapper) {
        this.sysPermissionService = sysPermissionService;
        this.sysUserMapper = sysUserMapper;
    }

    public SysUser selectUserByLoginName(String loginName) {
        return this.sysUserMapper.selectUserByLoginName(loginName);
    }

    public SysUser selectUserByPhoneNumber(String phonenumber) {
        return this.sysUserMapper.selectUserByPhoneNumber(phonenumber);
    }

    public Oauth2User createLoginUser(SysUser user, String clientId) {
        return new Oauth2User().setClientId(clientId).setLoginIp(user.getLoginIp()).setLoginName(user.getUserName()).setUserId(user.getUserId()).setDeptId(user.getDeptId()).setUsername(user.getNickName()).setPassword(user.getPassword()).setRoles(JSONUtil.toList((String)JSONUtil.toJsonStr(user.getRoles()), Oauth2Role.class)).setDept((Oauth2Dept)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)user.getDept()), Oauth2Dept.class)).setMenuPermissions(this.sysPermissionService.getMenuPermission(user, clientId)).setRolePermissions(this.sysPermissionService.getRolePermission(user, clientId));
    }
}

