/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.service.impl;

import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.entity.SysUser;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.service.ISysMenuService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.service.ISysPermissionService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.service.ISysRoleService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionService
implements ISysPermissionService<SysUser> {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysMenuService menuService;

    @Override
    public Set<String> getMenuPermission(SysUser user, String clientId) {
        HashSet<String> perms = new HashSet<String>();
        if (user.isAdmin()) {
            perms.add("*:*:*");
        } else {
            perms.addAll(this.menuService.selectMenuPermsByUserId(Long.valueOf(user.getUserId()), clientId));
        }
        return perms;
    }

    @Override
    public Set<String> getRolePermission(SysUser user, String clientId) {
        HashSet<String> roles = new HashSet<String>();
        if (user.isAdmin()) {
            roles.add("admin");
        } else {
            roles.addAll(this.roleService.selectRolePermissionByUserId(Long.valueOf(user.getUserId())));
        }
        return roles;
    }
}

