/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.service.impl;

import cn.hutool.core.lang.Validator;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.entity.MetaVo;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.entity.RouterVo;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.entity.SysMenu;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.mapper.SysMenuMapper;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.ruoyivue.service.ISysMenuService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysMenuServiceImpl
implements ISysMenuService {
    @Autowired
    private SysMenuMapper baseMapper;

    @Override
    public Set<String> selectMenuPermsByUserId(Long userId) {
        List<String> perms = this.baseMapper.selectMenuPermsByUserId(userId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtils.isNotEmpty((CharSequence)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    @Override
    public Set<String> selectMenuPermsByUserId(Long userId, String clientId) {
        List<String> perms = this.baseMapper.selectMenuPermsByUserIdAndClientId(userId, clientId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtils.isNotEmpty((CharSequence)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    @Override
    public List<SysMenu> selectMenuTreeByUserId(String clientId, String userId) {
        List<SysMenu> menus = null;
        menus = StringUtils.isNotEmpty((CharSequence)userId) && "1".equals(userId) ? this.baseMapper.selectMenuTreeAll(clientId) : this.baseMapper.selectMenuTreeByUserId(clientId, userId);
        return this.getChildPerms(menus, "0");
    }

    @Override
    public List<RouterVo> buildMenus(List<SysMenu> menus) {
        LinkedList<RouterVo> routers = new LinkedList<RouterVo>();
        for (SysMenu menu : menus) {
            RouterVo children;
            ArrayList<RouterVo> childrenList;
            RouterVo router = new RouterVo();
            router.setHidden("1".equals(menu.getVisible()));
            router.setName(this.getRouteName(menu));
            router.setPath(this.getRouterPath(menu));
            router.setComponent(this.getComponent(menu));
            router.setQuery(menu.getQuery());
            router.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), StringUtils.equals((CharSequence)"1", (CharSequence)menu.getIsCache()), menu.getPath()));
            List<SysMenu> cMenus = menu.getChildren();
            if (!cMenus.isEmpty() && "M".equals(menu.getMenuType())) {
                router.setAlwaysShow(true);
                router.setRedirect("noRedirect");
                router.setChildren(this.buildMenus(cMenus));
            } else if (this.isMenuFrame(menu)) {
                router.setMeta(null);
                childrenList = new ArrayList<RouterVo>();
                children = new RouterVo();
                children.setPath(menu.getPath());
                children.setComponent(menu.getComponent());
                children.setName(StringUtils.capitalize((String)menu.getPath()));
                children.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), StringUtils.equals((CharSequence)"1", (CharSequence)menu.getIsCache()), menu.getPath()));
                children.setQuery(menu.getQuery());
                childrenList.add(children);
                router.setChildren(childrenList);
            } else if ("0".equals(menu.getParentId()) && this.isInnerLink(menu)) {
                router.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon()));
                router.setPath("/inner");
                childrenList = new ArrayList();
                children = new RouterVo();
                String routerPath = this.innerLinkReplaceEach(menu.getPath());
                children.setPath(routerPath);
                children.setComponent("InnerLink");
                children.setName(StringUtils.capitalize((String)routerPath));
                children.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), menu.getPath()));
                childrenList.add(children);
                router.setChildren(childrenList);
            }
            routers.add(router);
        }
        return routers;
    }

    public boolean isMenuFrame(SysMenu menu) {
        return "0".equals(menu.getParentId()) && "C".equals(menu.getMenuType()) && menu.getIsFrame().equals("1");
    }

    public String getComponent(SysMenu menu) {
        String component = "Layout";
        if (StringUtils.isNotEmpty((CharSequence)menu.getComponent()) && !this.isMenuFrame(menu)) {
            component = menu.getComponent();
        } else if (StringUtils.isEmpty((CharSequence)menu.getComponent()) && !"0".equals(menu.getParentId()) && this.isInnerLink(menu)) {
            component = "InnerLink";
        } else if (StringUtils.isEmpty((CharSequence)menu.getComponent()) && this.isParentView(menu)) {
            component = "ParentView";
        }
        return component;
    }

    public boolean isInnerLink(SysMenu menu) {
        return menu.getIsFrame().equals("1") && Validator.isUrl((CharSequence)menu.getPath());
    }

    public boolean isParentView(SysMenu menu) {
        return !"0".equals(menu.getParentId()) && "M".equals(menu.getMenuType());
    }

    public String getRouteName(SysMenu menu) {
        String routerName = StringUtils.capitalize((String)menu.getPath());
        if (this.isMenuFrame(menu)) {
            routerName = "";
        }
        return routerName;
    }

    public String getRouterPath(SysMenu menu) {
        String routerPath = menu.getPath();
        if (!"0".equals(menu.getParentId()) && this.isInnerLink(menu)) {
            routerPath = this.innerLinkReplaceEach(routerPath);
        }
        if ("0".equals(menu.getParentId()) && "M".equals(menu.getMenuType()) && "1".equals(menu.getIsFrame())) {
            routerPath = "/" + menu.getPath();
        } else if (this.isMenuFrame(menu)) {
            routerPath = "/";
        }
        return routerPath;
    }

    public List<SysMenu> getChildPerms(List<SysMenu> list, String parentId) {
        ArrayList<SysMenu> returnList = new ArrayList<SysMenu>();
        for (SysMenu t : list) {
            if (!t.getParentId().equals(parentId)) continue;
            this.recursionFn(list, t);
            returnList.add(t);
        }
        return returnList;
    }

    public String innerLinkReplaceEach(String path) {
        return StringUtils.replaceEach((String)path, (String[])new String[]{"http://", "https://"}, (String[])new String[]{"", ""});
    }

    private void recursionFn(List<SysMenu> list, SysMenu t) {
        List<SysMenu> childList = this.getChildList(list, t);
        t.setChildren(childList);
        for (SysMenu tChild : childList) {
            if (!this.hasChild(list, tChild)) continue;
            this.recursionFn(list, tChild);
        }
    }

    private List<SysMenu> getChildList(List<SysMenu> list, SysMenu t) {
        ArrayList<SysMenu> tlist = new ArrayList<SysMenu>();
        for (SysMenu n : list) {
            if (!n.getParentId().equals(t.getMenuId())) continue;
            tlist.add(n);
        }
        return tlist;
    }

    private boolean hasChild(List<SysMenu> list, SysMenu t) {
        return this.getChildList(list, t).size() > 0;
    }
}

