/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.IUser;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.entity.Oauth2User;
import com.kdgcsoft.citybg.datacenter.authentication.user.common.domain.service.ISysUserService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.entity.SysRole;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.entity.SysUser;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.mapper.SysUserMapper;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.service.ISysPermissionService;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.util.IpUtils;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.util.ServletUtils;
import com.kdgcsoft.citybg.datacenter.oauth2.authentication.user.antvue.util.StringUtils;
import eu.bitwalker.useragentutils.UserAgent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SysUserServiceImpl<U extends IUser>
implements ISysUserService<SysUser> {
    private final SysUserMapper sysUserMapper;
    private final ISysPermissionService<SysUser> sysPermissionService;

    public SysUserServiceImpl(SysUserMapper sysUserMapper, ISysPermissionService<SysUser> sysPermissionService) {
        this.sysUserMapper = sysUserMapper;
        this.sysPermissionService = sysPermissionService;
    }

    public SysUser selectUserByLoginName(String loginName) {
        return this.sysUserMapper.selectUserByUserName(loginName, "0");
    }

    public SysUser selectUserByPhoneNumber(String phonenumber) {
        return this.sysUserMapper.selectUserByPhoneNumber(phonenumber, "0");
    }

    public Oauth2User createLoginUser(SysUser user, String clientId) {
        String[] roleKeys;
        Oauth2User oauth2User = new Oauth2User();
        oauth2User.setUserId(user.getId());
        Date loginDate = user.getLoginDate();
        if (Objects.nonNull(loginDate)) {
            oauth2User.setLoginTime(Long.valueOf(loginDate.getTime()));
        }
        HttpServletRequest request = ServletUtils.getRequestAttributes().getRequest();
        String header = request.getHeader("User-Agent");
        UserAgent userAgent = UserAgent.parseUserAgentString((String)header);
        String os = userAgent.getOperatingSystem().getName();
        oauth2User.setOs(os);
        String browser = userAgent.getBrowser().getName();
        oauth2User.setBrowser(browser);
        oauth2User.setDeptId(user.getDeptId());
        String address = IpUtils.getIpAddr(request);
        oauth2User.setIpaddr(address);
        Set<String> menuPermission = this.sysPermissionService.getMenuPermission(user, clientId);
        Set<String> rolePermission = this.sysPermissionService.getRolePermission(user, clientId);
        oauth2User.setUsername(user.getUserName());
        oauth2User.setPassword(user.getPassword());
        List<String> roleList = this.getRolesKeys(user);
        if (CollectionUtil.isNotEmpty(roleList) && (roleKeys = roleList.toArray(new String[0])).length > 0) {
            oauth2User.setRoleKeys(roleKeys);
        }
        oauth2User.setMenuPermissions(menuPermission);
        oauth2User.setRolePermissions(rolePermission);
        oauth2User.setUserJson(JSONObject.toJSONString((Object)user));
        return oauth2User;
    }

    private List<String> getRolesKeys(SysUser user) {
        ArrayList<String> rolesKeys = new ArrayList<String>();
        List<SysRole> sysRoles = user.getSysRoles();
        if (CollectionUtil.isNotEmpty(sysRoles)) {
            for (SysRole sysRole : sysRoles) {
                String roleKey = sysRole.getRoleKey();
                if (!StringUtils.isNotEmpty(roleKey)) continue;
                rolesKeys.add(roleKey);
            }
        }
        return rolesKeys;
    }
}

